#ifndef PCA9555_H
#define PCA9555_H

#include <mbed.h>


class PCA9555
{
    public:
        
        // ADDRESS
        static const int HARD_ADR       = 0x40;
        static const int USER_ADR_MASK  = 0x07;
        
        
        // PORT 0
        static const int PORT0_INPUT    = 0x00;
        static const int PORT0_OUTPUT   = 0x02;
        static const int PORT0_POLAR    = 0x04;
        static const int PORT0_CONFIG   = 0x06;  
        
        
        
        // PORT 1
        static const int PORT1_INPUT    = 0x01;
        static const int PORT1_OUTPUT   = 0x03;
        static const int PORT1_POLAR    = 0x05;
        static const int PORT1_CONFIG   = 0x07;  
        
        
        // BIT polarity
        static const int NORM_POL_BIT0  = (0 << 0);
        static const int NORM_POL_BIT1  = (0 << 1);
        static const int NORM_POL_BIT2  = (0 << 2);
        static const int NORM_POL_BIT3  = (0 << 3);
        static const int NORM_POL_BIT4  = (0 << 4);
        static const int NORM_POL_BIT5  = (0 << 5);
        static const int NORM_POL_BIT6  = (0 << 6);
        static const int NORM_POL_BIT7  = (0 << 7);
        
        static const int INV_POL_BIT0   = (1 << 0);
        static const int INV_POL_BIT1   = (1 << 1);
        static const int INV_POL_BIT2   = (1 << 2);
        static const int INV_POL_BIT3   = (1 << 3);
        static const int INV_POL_BIT4   = (1 << 4);
        static const int INV_POL_BIT5   = (1 << 5);
        static const int INV_POL_BIT6   = (1 << 6);
        static const int INV_POL_BIT7   = (1 << 7);
        
        
        
        
        static const int BIT0           = 0;
        static const int BIT1           = 1;
        static const int BIT2           = 2;
        static const int BIT3           = 3;
        static const int BIT4           = 4;
        static const int BIT5           = 5;
        static const int BIT6           = 6;
        static const int BIT7           = 7;
    
    
    
        
        //public:
            // definitions
            typedef enum { _PORT0, _PORT1, _BOTH} _GPIO;
             
            typedef union {
                struct{
                    unsigned int B0 : 1;
                    unsigned int B1 : 1;
                    unsigned int B2 : 1;
                    unsigned int B3 : 1;
                    unsigned int B4 : 1;
                    unsigned int B5 : 1;
                    unsigned int B6 : 1;
                    unsigned int B7 : 1;
                }Pin;
                
                uint8_t uiPort;
            }GPIO;
        
    
            // function
            PCA9555(I2C *_i2c, uint8_t uiAdr);    
            
           
            bool confDirGPIO(_GPIO gpio, uint8_t uiData0, uint8_t uiData1 = NULL);
            
            
            uint8_t getGPIO0(bool bUpdate);
            bool getGPIO0_B0(bool bUpdate);
            bool getGPIO0_B1(bool bUpdate);
            bool getGPIO0_B2(bool bUpdate);
            bool getGPIO0_B3(bool bUpdate);
            bool getGPIO0_B4(bool bUpdate);
            bool getGPIO0_B5(bool bUpdate);
            bool getGPIO0_B6(bool bUpdate);
            bool getGPIO0_B7(bool bUpdate);
            
            uint8_t getGPIO1(bool bUpdate);
            bool getGPIO1_B0(bool bUpdate);
            bool getGPIO1_B1(bool bUpdate);
            bool getGPIO1_B2(bool bUpdate);
            bool getGPIO1_B3(bool bUpdate);
            bool getGPIO1_B4(bool bUpdate);
            bool getGPIO1_B5(bool bUpdate);
            bool getGPIO1_B6(bool bUpdate);
            bool getGPIO1_B7(bool bUpdate);
            
            
            bool setGPIO(_GPIO gpio, uint8_t uiData0, uint8_t uiData1 = NULL);
            bool setGPIO0_B0(bool bBit);
            bool setGPIO0_B1(bool bBit);
            bool setGPIO0_B2(bool bBit);
            bool setGPIO0_B3(bool bBit);
            bool setGPIO0_B4(bool bBit);
            bool setGPIO0_B5(bool bBit);
            bool setGPIO0_B6(bool bBit);
            bool setGPIO0_B7(bool bBit);
            
            bool setGPIO1_B0(bool bBit);
            bool setGPIO1_B1(bool bBit);
            bool setGPIO1_B2(bool bBit);
            bool setGPIO1_B3(bool bBit);
            bool setGPIO1_B4(bool bBit);
            bool setGPIO1_B5(bool bBit);
            bool setGPIO1_B6(bool bBit);
            bool setGPIO1_B7(bool bBit);
            
            // variable        
            static const _GPIO PORT0  = _PORT0;
            static const _GPIO PORT1  = _PORT1;
            static const _GPIO BOTH   = _BOTH;        
            
            GPIO GPIO0, GPIO1;
            
            
            //uint8_t uiGPIO0, uiGPIO1;
        
        
    private:
        // functions
        bool getGPIO(_GPIO gpio);
        
        // variable
        const uint8_t PCA9555_W;
        const uint8_t PCA9555_R;

        
        
        char cCmd[10];
        bool bAck;
        
        // Class
        I2C *i2c;
};

#endif
