#include <PCA9555.h>

//#include <mbed.h>

//******************************************************************************//
// uiAdr:   user address [A2...A0]
//******************************************************************************//
PCA9555::PCA9555(I2C *_i2c, uint8_t uiAdr)                                      //
    :   PCA9555_W( HARD_ADR | (uiAdr & USER_ADR_MASK) << 1),// Initialisation of const WRITE
        PCA9555_R( PCA9555_W | 0x01 ){                                   // Initialisation of const READ
        
    i2c = _i2c;                                                                 //
    bAck = false;                                                               //    
}



//******************************************************************************//
//  If a bit in this register is set (written with ‘1’), the corresponding port 
//  pin is enabled as an input with high-impedance output driver. If a bit in 
//  this register is cleared (written with ‘0’), the corresponding port pin is
//  enabled as an output.
//******************************************************************************//    
bool PCA9555::confDirGPIO(_GPIO gpio, uint8_t uiData0, uint8_t uiData1){    

    if (gpio == BOTH){                                                          // both GPIO ports
        cCmd[0] = PORT0_CONFIG;                                                 // start with GPIO Port0
        cCmd[1] = uiData0;                                                      // uiData0 for GPIO Port 0
        cCmd[2] = uiData1;                                                      // uiData1 for GPIO Port 1
        
        bAck = i2c->write(PCA9555_W, cCmd, 3);                                      // send via I2C
        
    } else {                                                                    // only
        if (gpio == PORT0)  cCmd[0] = PORT0_CONFIG;                             // Port0
        else                cCmd[0] = PORT1_CONFIG;                             // Port1
        
        cCmd[1] = uiData0;                                                      // uiData
        bAck = i2c->write(PCA9555_W, cCmd, 2);                                  // send via I2C
    }
    
    return bAck;                                                                // return (N)ACK
}


//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO(_GPIO gpio){
    
    if (gpio == BOTH){                                                          // both GPIO ports
        cCmd[0] = PORT0_INPUT;                                                  // start with GPIO Port0
        
        bAck = i2c->write(PCA9555_W, cCmd, 1);                                      // send via I2C
        bAck = i2c->read(PCA9555_R, cCmd, 2);                                        // send via I2C
        GPIO0.uiPort = cCmd[0];
        GPIO1.uiPort = cCmd[1];
        
    } else {                                                                    // only
        if (gpio == PORT0)  cCmd[0] = PORT0_INPUT;                              // Port0
        else                cCmd[0] = PORT1_INPUT;                              // Port1
        
        bAck = i2c->write(PCA9555_W, cCmd, 1);                                      // send via I2C
        bAck = i2c->read(PCA9555_W, cCmd, 1);                                       // send via I2C
        
        if (gpio == PORT0)  GPIO0.uiPort = cCmd[0];                             // Port0
        else                GPIO1.uiPort = cCmd[0];                             // Port0
    }
    
    return bAck;                                                                // return (N)ACK
}
    

     
//******************************************************************************//
// 
//******************************************************************************//    
 uint8_t PCA9555::getGPIO0(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.uiPort;
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B0(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return (bool) GPIO0.Pin.B0;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B1(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.Pin.B1;
     
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B2(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.Pin.B2;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B3(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.Pin.B3;
     
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B4(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.Pin.B4;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B5(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.Pin.B5;
     
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B6(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.Pin.B6;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO0_B7(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO0.Pin.B7;
     
}         
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 uint8_t PCA9555::getGPIO1(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.uiPort;
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B0(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B0;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B1(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B1;
     
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B2(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B2;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B3(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B3;
     
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B4(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B4;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B5(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B5;
     
}



//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B6(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B6;
}
     
     
     
//******************************************************************************//
// 
//******************************************************************************//    
 bool PCA9555::getGPIO1_B7(bool bUpdate){
     
     if(bUpdate)    getGPIO(BOTH);
     
     return GPIO1.Pin.B7;
     
}



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO(_GPIO gpio, uint8_t uiData0, uint8_t uiData1)
{       
    if(gpio == BOTH){                                                           // both GPIO ports
        cCmd[0] = PORT0_OUTPUT;                                                 // start with GPIO Port0
        cCmd[1] = uiData0;                                                      // uiData0 for GPIO Port 0
        cCmd[2] = uiData1;                                                      // uiData1 for GPIO Port 1
        
        bAck = i2c->write(PCA9555_W, cCmd, 3);                                      // send via I2C
        
    } else {                                                                    // only
        if (gpio == PORT0)  cCmd[0] = PORT0_OUTPUT;                             // Port0
        else                cCmd[0] = PORT1_OUTPUT;                             // Port1
        
        cCmd[1] = uiData0;                                                      // uiData
        bAck = i2c->write(PCA9555_W, cCmd, 2);                                      // send via I2C
    }
    
    return bAck;                                                                // return (N)ACK
}


//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO0_B0(bool bBit){
    
    GPIO0.Pin.B0 = bBit;
    
    return setGPIO(PORT0, GPIO0.uiPort);
}
    


  
//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO0_B1(bool bBit){
    
    GPIO0.Pin.B1 = bBit;
    
    return setGPIO(PORT0, GPIO0.uiPort);
} 
   
   
   
//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO0_B2(bool bBit){
    
    GPIO0.Pin.B2 = bBit;
    
    return setGPIO(PORT0, GPIO0.uiPort);
}    



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO0_B4(bool bBit){
    
    GPIO0.Pin.B4 = bBit;
    
    return setGPIO(PORT0, GPIO0.uiPort);
} 



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO0_B5(bool bBit){
    
    GPIO0.Pin.B5 = bBit;
    
    return setGPIO(PORT0, GPIO0.uiPort);
}    



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO0_B6(bool bBit){
    
    GPIO0.Pin.B6 = bBit;
    
    return setGPIO(PORT0, GPIO0.uiPort);
} 



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO0_B7(bool bBit){
    
    GPIO0.Pin.B7 = bBit;
    
    return setGPIO(PORT0, GPIO0.uiPort);
}    



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO1_B0(bool bBit){
    
    GPIO1.Pin.B0 = bBit;
    
    return setGPIO(PORT1, GPIO1.uiPort);
}
    


  
//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO1_B1(bool bBit){
    
    GPIO1.Pin.B1 = bBit;
    
    return setGPIO(PORT1, GPIO1.uiPort);
} 
   
   
   
//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO1_B2(bool bBit){
    
    GPIO1.Pin.B2 = bBit;
    
    return setGPIO(PORT1, GPIO1.uiPort);
}    



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO1_B4(bool bBit){
    
    GPIO1.Pin.B4 = bBit;
    
    return setGPIO(PORT1, GPIO1.uiPort);
} 



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO1_B5(bool bBit){
    
    GPIO1.Pin.B5 = bBit;
    
    return setGPIO(PORT1, GPIO1.uiPort);
}    



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO1_B6(bool bBit){
    
    GPIO1.Pin.B6 = bBit;
    
    return setGPIO(PORT1, GPIO1.uiPort);
} 



//******************************************************************************//
//
//******************************************************************************//
bool PCA9555::setGPIO1_B7(bool bBit){
    
    GPIO1.Pin.B7 = bBit;
    
    return setGPIO(PORT1, GPIO1.uiPort);
}
    