#ifndef AT24C64D_H
#define  AT24C64D_H

#include "mbed.h"
#include "AT24C.h"

class  AT24C64D : public AT24C
{

    public:
        static const uint16_t ADDR_MASK = 0x1FFF;
        
        //variable
        bool bAck;
        static const uint16_t READY_TIME_US = 5000;                             // Write time in us
        static const uint16_t READY_TIME_MS = 5;
        
    
        // function
        AT24C64D(I2C *_i2c, uint8_t uiAddr);
        virtual uint8_t getAddrBus();
        virtual uint8_t getAddrUser();
        
        virtual bool write(char * cData);
        virtual bool write(uint16_t uiAddr, char *cData);
        virtual bool write(uint16_t uiAddr, char * cData, uint16_t uiLength);
        
        
        virtual bool read(char * cData);
        virtual bool read(uint16_t uiAddr, char *cData);
        virtual bool read(uint16_t uiAddr, char * cData, uint16_t uiLength);
        
        virtual void reset();
        virtual bool erase();        
        virtual bool isReady();
        
        
        
        virtual void setAddrWrite(uint16_t Addr);
        virtual uint16_t getAddrWrite();
        virtual void incAddrWrite();
        virtual void decAddrWrite();
         
         
        virtual void setAddrRead(uint16_t Addr);
        virtual uint16_t getAddrRead();
        virtual void incAddrRead();
        virtual void decAddrRead();

         
    private:
    
        // constants

        const uint8_t AT24C64D_W;
        const uint8_t AT24C64D_R;
        static const int HARD_ADDR           = 0xA0;                                 
        static const int USER_ADDR_MASK      = 0x07;

            
        
        static const uint8_t SIZE_PAGE      = 32;                               // 32-Byte Page Write Mode (Partial Page Writes Allowed)
        static const uint16_t MEM_ADDR_MAX  = 8192;                             // 0...4095
        static const uint16_t TIMEOUT_VAL   = 1000;
        
        // variable
        bool bReady;
        bool bTimerRun;
        uint16_t uiTimeOut;
        
        uint16_t uiAddrWrite;
        uint16_t uiAddrRead;
        uint16_t uiAddrTemp; 
         
        uint8_t uiAddrQuotient;                                                  // 
        uint8_t uiAddrRemainder;                                                 //         
        
        char cBuffer[2 + SIZE_PAGE];                                            // 2 Address Bytes + 32 Byte Data
        
        // Class
        I2C *i2c;
        Timer *timer;
        
        
        // functions
        //virtual void setReady();
        void startTimer();
        bool ACKpolling(uint8_t uiAdr);
        //virtual void abortTransmition();

};

#endif
