#ifndef APPLICATION_H
#define APPLICATION_H

#include "HttpServer.h"
#include "WatchDogTimer.h"
#include "SDFileSystem.h"
#include "ActuatorsController.h"

class Application {
    private:
        SPI *spiHandler;
        
        WatchDogTimer* watchDog;
        HttpServer* httpServer;
        FileSystemLike* localFileSystem;
        FileSystemLike* sdFileSystem;
        ActuatorsController* actuatorsController;
        
        void setup();
        void loop();
        int isSystemOnline();
        void recoverSystem();
        void applicationReset();
        void handleFaultyResetRecovery();
    public:
        Application();
        ~Application();
        
        void run();
};

#endif