#include "Application.h"

#define WATCH_DOG_TIMER_TRIGGER_TIME 5 //seconds

extern "C" void mbed_reset();

Application::Application() {
}

void Application::setup() {
    
    // WatchDog reset ?
    if (WatchDogTimer::systemResetReason() == SYSTEM_RESET_WATCH_DOG) {
        handleFaultyResetRecovery();
    }
    
    // setup ethernet
    
    
    // start spi
    spiHandler = new SPI(p5, p6, p7);
    spiHandler->frequency(100000); // 100 khz for slow periperals intialization
    
    // starting the file systems
    localFileSystem = new LocalFileSystem("local");
    sdFileSystem = new SDFileSystem(spiHandler, p8, "sd");
    
    spiHandler->frequency(16000000); // 4 Mhz spi normal operation frequency
    
    // start the http api server
    httpServer = new HttpServer();
    httpServer->start();
    
    // enable watchdog timer
    watchDog = new WatchDogTimer(WATCH_DOG_TIMER_TRIGGER_TIME);    
}

void Application::handleFaultyResetRecovery() {
    
}

void Application::loop() {
    
}

void Application::run() {
    setup();
    while(1) {
        watchDog->feed();
        if (!isSystemOnline()) {
            recoverSystem();
        }
        watchDog->feed();
        loop();
        Thread::wait(100);
    }
}

int Application::isSystemOnline() {
    return httpServer->isAlive();
}

void Application::recoverSystem() {
    httpServer->restart();
}

void Application::applicationReset() {
    wait(5);
    mbed_reset();    
}

Application::~Application() {

}