/**
 * Apache License
 * Version 2.0, January 2004
 * http://www.apache.org/licenses/
 */

#include "WatchDogTimer.h"

int WatchDogTimer::systemResetReason() {
    return ((LPC_WDT->WDMOD >> 2) & 1) ? SYSTEM_RESET_WATCH_DOG : SYSTEM_RESET_NORMAL;
}

WatchDogTimer::WatchDogTimer(float seconds) {
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
    LPC_WDT->WDTC = seconds * (float)clk;   // Load WD Timer Constant with value determined by float s
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset        
    feed();
}

void WatchDogTimer::feed() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}