// Demo for the uLCD-144-G2 based on the work by Jim Hamblen

#include "mbed.h"
#include "uLCD_4DGL.h"

// TX, RX, and RES pins
uLCD_4DGL uLCD(p9,p10,p11);

int main() {

    int x;
    int y;
    int radius;
    int vx;

    // Test comment
    // Set our UART baudrate to something reasonable
    uLCD.baudrate(115200);

    // Change background color (must be called before cls)
    uLCD.background_color(WHITE);

    // Clear screen with background color
    uLCD.cls();

    // Change background color of text
    uLCD.textbackground_color(WHITE);

    // Make some colorful text
    uLCD.locate(4, 1);      // Move cursor
    uLCD.color(BLUE);
    uLCD.printf("This is a\n");
    uLCD.locate(5, 3);      // Move cursor
    uLCD.text_width(2);     // 2x normal size
    uLCD.text_height(2);    // 2x normal size
    uLCD.color(RED);        // Change text color
    uLCD.printf("TEST");
    uLCD.text_width(1);     // Normal size
    uLCD.text_height(1);    // Normal size
    uLCD.locate(3, 6);      // Move cursor   
    uLCD.color(BLACK);      // Change text color
    uLCD.printf("of my new LCD");

    // Initial parameters for the circle
    x = 50;
    y = 100;
    radius = 4;
    vx = 1;

    // Make a ball bounce back and forth
    while (1) {

        // Draw a dark green
        uLCD.filled_circle(x, y, radius, 0x008000);

        // Bounce off the edges
        if ((x <= radius + 1) || (x >= 126 - radius)) {
            vx = -1 * vx;
        }

        // Wait before erasing old circle
        wait(0.02);         // In seconds

        // Erase old circle
        uLCD.filled_circle(x, y, radius, WHITE);

        // Move circle
        x = x + vx;
    }
}
