/* mbed Repetitive Interrupt Timer Library
 * Copyright (c) 2011 wvd_vegt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "RIT.h"
#include "FastAnalogIn.h"

//We'll be using the Usb Serial port
Serial serial(USBTX, USBRX); //tx, rx

DigitalOut rit_led(LED3);

FastAnalogIn a1(p19,true);   //Ain1  - Peel Force
FastAnalogIn a2(p20,true);   //Ain2  - Seal Force

#define SAMPLE_BUFFER_LENGTH 1000

volatile uint32_t rithits = 0;       //timer1 stops when timer1hits==imer1loop

volatile bool done = false;
volatile short flip = 1;

Timer rit_timing;

static short adc1[SAMPLE_BUFFER_LENGTH] __attribute__ ((aligned (64)));
static short adc2[SAMPLE_BUFFER_LENGTH] __attribute__ ((aligned (64)));
static int Timing01[SAMPLE_BUFFER_LENGTH];

void RIT_IRQHandler(void)
{
    if (!done) {
        Timing01[rithits] = rit_timing.read_us();
        if (flip%2) {
            adc1[rithits]=a1.read_u16();
        } else {
            adc2[rithits]=a2.read_u16();

            //Count Hits.
            rithits++;
        }

        flip ++;

        //Flash Led.
        //rit_led=!rit_led;
        done = rithits==SAMPLE_BUFFER_LENGTH;
    }
}

/*
LPC_TIM1->IR = 0x1UL;                                       // Re-enabled

Timing01[timer1hits] = adc_stamper.read_us();

//TODO Toggle Channel Mask (01 to 01 in ADCR).
//     Take twice the number of samples at half the sampling time
//     So 2000 samples (1000+1000) at 0.5ms -> 1000 pairs in 1 sec.

switch (LPC_ADC->ADSTAT & (t_ch0|t_ch1))
{
case t_ch0:
    Samples0[timer1hits] = LPC_ADC->ADDR4;
    break;
}
}
*/
//https://developer.mbed.org/forum/mbed/topic/370/
RIT rit(1000);

//https://developer.mbed.org/handbook/Ticker
//Ticker ticker;

//void tock()
//{
//    Timing01[rithits] = rit_timing.read_us();
//}

int main()
{
    // Set the Baudrate.
    serial.baud(115200);

    rit.setup_us(10);

    rit.append(RIT_IRQHandler);

    rit.enable();
    rit_timing.start();

    while (!done) {
        // wait(0.001);
    }

    rit_timing.stop();
    rit.disable();

    rit.unappend();

    for (int i=0; i<SAMPLE_BUFFER_LENGTH; i++) {
        serial.printf("%3d %6.3f - %6d - %6d\r\n",i, Timing01[i]/1000.0f, adc1[i], adc2[i]);
    }
    serial.printf("%3d %6.3f - %6d - %6d\r\n",0, Timing01[0]/1000.0f, adc1[0], adc2[0]);

    printf("COMPVAL=%d\r\n", LPC_RIT->RICOMPVAL); // 959 (960-1)
    printf("COUNTER=%d\r\n", LPC_RIT->RICOUNTER); // 807?
    printf("HITS=%d\r\n", rithits);
    printf("ELAPSED=%0.3f ms\r\n", rit_timing.read_us()/1000.0f);
    printf("ELAPSED=%0.3f ms\r\n", (Timing01[SAMPLE_BUFFER_LENGTH-1]-Timing01[0])/1000.0f);

    /*
        //
        printf("Requested max sample rate is %u, actual max sample rate is %u.\r\n",
               SAMPLE_RATE, adc.actual_sample_rate());

        adc.startmode(0,0);

        adc.burst(1);

        adc.setup(p15,1);
        adc.setup(p16,1);

        //For burst mode, only one interrupt is required
        //which can be on any enabled pin. We have enabled all
        //of them here.
        adc.interrupt_state(p15,1);
        adc_timing.reset();
        adc_timing.start();

        //10 ms sample time.
        rit.setup_ms(10);

        //Clear ADC Storage stuff...
        adchits = 0;
        memset(Samples0, 0,sizeof(Samples0));
        memset(Samples1, 0,sizeof(Samples1));

        rit.append(Adc_IRQHandler);

        rit_timing.reset();
        rit_timing.start();

        rit.enable();

        //To be sure...
        while (adchits!=MAX_SAMPLES) {
            wait(0.01);
        }

        rit.disable();

        rit_timing.stop();

        rit.unappend();

        for (int i=0; i < MAX_SAMPLES; i++) {
            printf("%04d=%04d | %04d @ %08d\r\n", i, Samples0[i], Samples1[i], Timing01[i]);
        }

        printf("ELAPSED=%0.2f ms\r\n", rit_timing.read_us()/1000);
        printf("HITS=%d\r\n", adchits);

        adc.burst(0);

        adc.setup(p15,0);
        adc.setup(p16,0);

        adc.interrupt_state(p15,0);

        adc_timing.stop();
    */
}