#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "element.h"


void init(int n);
void render(int n);
void update(int &n);
void hitwall(int &n);
void welcome();
void eat(int &n);
void hitself(int &n);

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
element e;
int main(){
    int n=20;
    int fps =8;
    init(n);
    welcome();
    render(n);
    wait(1.0f/fps); 
    while(1){
        
        update(n);
        render(n);
        wait(1.0f/fps); 
    }
}

void init(int n){
    lcd.init();
    pad.init();
    e.init(2,20,20,30,30,n);
  
}
void render(int n){
    lcd.clear();
    e.draw(lcd,n);
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.refresh();
}
void update(int &n){
    e.input(pad);
    e.move(n);
    eat(n);
    hitwall(n);
    hitself(n);
    
}
void hitwall(int &n){
    if(e.getsnakepos(0).x<=0 || e.getsnakepos(0).x+2>=WIDTH ||e.getsnakepos(0).y<=0||e.getsnakepos(0).y+2>=HEIGHT)
    {
       
       while ( pad.check_event(Gamepad::BACK_PRESSED) == false){
        lcd.clear();
        lcd.printString("    FAILED    ",0,1);
        lcd.printString(" YOU HIT WALL",0,2);
        lcd.printString("  PRESS BACK    ",0,3);  
        char buffer[14];
         sprintf(buffer,"SCORE = %2d ",n-20);
         lcd.printString(buffer,0,5);  
        lcd.refresh();
      
        
    }
    n=20;
    e.init(2,20,20,30,30,n);
    
    
}

}
void welcome() {
    
    lcd.printString("     SNAKE!    ",0,1);  
    lcd.printString("  Press Start to play ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
} 
void eat(int &n ){

    for(int i=0;i<3;i++)
    {
        if(e.getsnakepos(0).y+i ==e.getfoodpos().y && e.getsnakepos(0).x ==e.getfoodpos().x )
        {
            e.update();
            n+=1;
           
        }
        if(e.getsnakepos(0).y+2==e.getfoodpos().y &&e.getsnakepos(0).x+i==e.getfoodpos().x)
        {
            e.update();
            n+=1;
          
        }
        if(e.getsnakepos(0).y==e.getfoodpos().y &&e.getsnakepos(0).x+i==e.getfoodpos().x)
        {
            e.update();
            n+=1;
          
        }
          if(e.getsnakepos(0).y+i==e.getfoodpos().y &&e.getsnakepos(0).x+2==e.getfoodpos().x)
        {
            e.update();
            n+=1;
          
        }
       //x,y
        if(e.getsnakepos(0).y+i ==e.getfoodpos().y && e.getsnakepos(0).x ==e.getfoodpos().x+1 )
        {
            e.update();
            n+=1;
          
        }
        if(e.getsnakepos(0).y+2==e.getfoodpos().y &&e.getsnakepos(0).x+i==e.getfoodpos().x+1)
        {
            e.update();
            n+=1;
           
        }
        if(e.getsnakepos(0).y==e.getfoodpos().y &&e.getsnakepos(0).x+i==e.getfoodpos().x+1)
        {
            e.update();
            n+=1;
         
        }
          if(e.getsnakepos(0).y+i==e.getfoodpos().y &&e.getsnakepos(0).x+2==e.getfoodpos().x+1)
        {
            e.update();
            n+=1;
           
        }
        //x+1,y
        
         if(e.getsnakepos(0).y+i ==e.getfoodpos().y+1 && e.getsnakepos(0).x ==e.getfoodpos().x )
        {
            e.update();
            n+=1;
           
        }
        if(e.getsnakepos(0).y+2==e.getfoodpos().y+1 &&e.getsnakepos(0).x+i==e.getfoodpos().x)
        {
            e.update();
            n+=1;
          
        }
        if(e.getsnakepos(0).y==e.getfoodpos().y+1&&e.getsnakepos(0).x+i==e.getfoodpos().x)
        {
            e.update();
            n+=1;
         
        }
          if(e.getsnakepos(0).y+i==e.getfoodpos().y+1 &&e.getsnakepos(0).x+2==e.getfoodpos().x)
        {
            e.update();
            n+=1;
         
        }
        //x,y-1
        if(e.getsnakepos(0).y+i ==e.getfoodpos().y+1 && e.getsnakepos(0).x ==e.getfoodpos().x +1)
        {
            e.update();
            n+=1;
          
        }
        if(e.getsnakepos(0).y+2==e.getfoodpos().y+1 &&e.getsnakepos(0).x+i==e.getfoodpos().x+1)
        {
            e.update();
            n+=1;
            
        }
        if(e.getsnakepos(0).y==e.getfoodpos().y+1 &&e.getsnakepos(0).x+i==e.getfoodpos().x+1)
        {
            e.update();
            n+=1;
       
        }
          if(e.getsnakepos(0).y+i==e.getfoodpos().y+1 &&e.getsnakepos(0).x+2==e.getfoodpos().x+1)
        {
            e.update();
            n+=1;
         
        }
    }
        
}
void hitself(int &n){
    for(int i=2;i<n;i++)
    {
        for(int j=0;j<3;j++)
        {
        if(e.getsnakepos(0).x==e.getsnakepos(i).x+1 && e.getsnakepos(0).y+j==e.getsnakepos(i).y+1)
        {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false)
            {
            lcd.clear();
            lcd.printString(" FAILED    ",0,1);
            lcd.printString(" YOU HIT SELF!    ",0,2);
            lcd.printString(" PRESS BACK    ",0,3);  
            char buffer[14];
            sprintf(buffer,"SCORE = %2d ",n-20);
            lcd.printString(buffer,0,4);  
            lcd.refresh();
            lcd.clear();
            
        }
         n=20;
        e.init(2,20,20,30,30,n);
      
       
        }
        
        
        
        
         if(e.getsnakepos(0).x+j==e.getsnakepos(i).x+1 && e.getsnakepos(0).y==e.getsnakepos(i).y+1)
        {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false)
            {
            lcd.clear();
            lcd.printString(" HIT SELF!    ",0,2);
            lcd.printString(" PRESS BACK    ",0,3);
            char buffer[14];
            sprintf(buffer,"SCORE = %2d ",n-20);
            lcd.printString(buffer,0,4);      
            lcd.refresh();
            lcd.clear();
           
            }
             n=20;
            e.init(2,20,20,30,30,n);
       
        }
        
        
        
        
        
        
         if(e.getsnakepos(0).x+j==e.getsnakepos(i).x+1 && e.getsnakepos(0).y+2==e.getsnakepos(i).y+1)
        {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false)
            {
            lcd.clear();
            lcd.printString(" HIT SELF!    ",0,2);
            lcd.printString(" PRESS BACK    ",0,3); 
            char buffer[14];
            sprintf(buffer,"SCORE = %2d ",n-20);
            lcd.printString(buffer,0,4);   
            lcd.refresh();
            lcd.clear();
          
                 
            }
            n=20;
            e.init(2,20,20,30,30,n);
       
        }
        
        
         if(e.getsnakepos(0).x+2==e.getsnakepos(i).x+1 && e.getsnakepos(0).y+j==e.getsnakepos(i).y+1)
        {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false)
            {
            lcd.clear();
            lcd.printString(" HIT SELF!    ",0,2);
            lcd.printString(" PRESS BACK    ",0,3);
            char buffer[14];
            sprintf(buffer,"SCORE = %2d ",n-20);
            lcd.printString(buffer,0,4);    
            lcd.refresh();
            lcd.clear();
           
                 
            }
            n=20;
            e.init(2,20,20,30,30,n);
       
        }
        
        }
        }
}

            