#ifndef ELEMENT_H
#define ELEMENT_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** snakegame
* @brief snakegame
* @author WUWEILONG 201282622
* @date May.2019
*/
class element
{

public:
     /** Constructor */
     element();
      /** Destructor */
    ~element();
  /** initialize the snake and the food  
  * @param the value of the foodsize 
  * @param the value of the x of coordinates of the food
  * @param the value of the y of coordinates of the food
  * @param the value of the x of coordinates of the snake
  * @param the value of the y of coordinates of the snake
  * @param the value of the snakelength
  */
  
    void init(int foodsize,int foodx,int foody,int snakex,int snakey,int n);
    /** get the position of food
    *@return position of food 
    */
    Vector2D getfoodpos();
    /** get the position of the n th segment of snake
    *@return position of the n th segment of snake 
    */
    Vector2D getsnakepos(int n);
    /** draw the graph 
    *@param the N5110 lcd
    *@param the value of length of snake
    */
    void draw(N5110 &lcd,int n);
    /** upadate the coordinates of food as a random value in a specific range
    */
    void update();
    /** input the control 
    *@param the Gamepad
    */
    void input(Gamepad &pad);
    /**  move the snake 
    *@param the length of snake 
    */
    void move(int n);
    
    
    
   
    /// accessors and mutators
    
private:

    int _size;
    Vector2D _foodpos;
    Vector2D _snakebody[];
    Direction _d;
    
};
#endif