#include "test_vector.h"
#include "main_init.h"

test_vector::test_vector(PinName pin, captureMode mode, uint32_t bufferSize) : _interrupt(pin) 
{
    _pinName = pin;
    _bufferSize = bufferSize;
    _mode = mode; 
}

test_vector::~test_vector()
{
}



void test_vector::_handlePinRiseIRQ() 
{
    switch(_mode){
        case rise_rise:
            _savePeriod();
            _sampleCaptureTimer();
            break;
        case rise_fall:
             _sampleCaptureTimer();
            break;
        case fall_rise:
            _savePeriod();
            break;
        case fall_fall:
            break;
        case both:
            _savePeriod();
            _sampleCaptureTimer();
            break;
        default:
            _savePeriod();
            _sampleCaptureTimer();
    }
}
 
void test_vector::_handlePinFallIRQ() 
{
    switch(_mode){
        case rise_rise:
            break;
        case rise_fall:
             _savePeriod();
            break;
        case fall_rise:
            _sampleCaptureTimer();
            break;
        case fall_fall:
            _savePeriod();
            _sampleCaptureTimer();
            break;
        case both:
            _savePeriod();
            _sampleCaptureTimer();
            break;
        default:
            _savePeriod();
            _sampleCaptureTimer();
    }
}




void test_vector::configureTimer()
{
        
    _timer_value = 0;
    _period = 0;

    LPC_SC->PCONP |= (1UL << 23) | (1UL << 15);   /* enable timer 3 power and the gpio*/
    LPC_SC->PCLKSEL1 |= (1UL << 14);  /* Timer3 clock is SystemCLK */
    
    LPC_TIM3->PR = SystemCoreClock/1000000; /* should increment once a microsecond. */
    LPC_TIM3->MR0 = 0;
    LPC_TIM3->MR1 = 0;
    LPC_TIM3->MR2 = 0;
    LPC_TIM3->MR3 = 0;
    LPC_TIM3->MCR = 0;  
    LPC_TIM3->CTCR &= ~(3 << 0);  /* Timer mode */
    LPC_TIM3->CCR|=((1<<0)|(1<<1)); /* capture rising & falling without interrupt on channel 0 */

    switch(_pinName){
        /* configure the pin ==> 2'11 at offset 14 is to enable CAP3.0 or p15 */
        case p15: 
            LPC_PINCON->PINSEL1 |= (3UL << 14);
            LPC_TIM3->IR |= (1 << 4UL);  //enbale cpature channel 0 event 
            break;
        /* configure the pin ==> 2'11 at offset 16 is to enable CAP3.1 or p16 */
        case p16: 
            LPC_PINCON->PINSEL0 |= (3UL << 16);
            LPC_TIM3->IR |= (1 << 5UL);  /* enbale cpature channel 1 event */
            break;
        /* default is p15 */
        default: 
            LPC_PINCON->PINSEL1 |= (3UL << 14);
            LPC_TIM3->IR |= (1 << 4UL);  /* enbale cpature channel 0 event */      
    }
    
}

void test_vector::startTimer()
{
    
    LPC_TIM3->TCR = 2;  // reset 
    LPC_TIM3->TCR = 1;  //start timer 
    _interrupt.rise(callback(this, &test_vector::_handlePinRiseIRQ)); /* rising edge IRQ routine*/
    _interrupt.fall(callback(this, &test_vector::_handlePinFallIRQ)); /* falling edge IRQ routine*/
    
}

void test_vector::stopTimer()
{

    LPC_TIM3->TCR = 2;  // reset
    _interrupt.rise(NULL);  /*disable pin interrupt*/
    _interrupt.fall(NULL);  /*disable pin interrupt*/
    led1 = 0;
    led2 = 0;
}

void test_vector::_sampleCaptureTimer()
{
    _timer_value = LPC_TIM3->CR0;
}

void test_vector::_savePeriod()
{
    _period = LPC_TIM3->CR0 - _timer_value;
    if( _period_idx <= _bufferSize && !_bufferFull) 
    {
        _ptr_period_arr[_period_idx] = _period;
//        _ptr_period_arr[_period_idx] = _bufferSize - _period_idx; /* to test */
        _period_idx++;
        _bufferFull = false;
        led1 = 1;
    }
    else
    {
        _bufferFull = true; 
        led1 = 0;   
    }
}


void test_vector::setUpTimerBuffer()
{
//    _ptr_period_arr = (uint32_t*) malloc(_bufferSize * sizeof(uint32_t));  /* always pre-allocate 1000 words buffer*/
    _ptr_period_arr = new uint32_t[_bufferSize]; 
    _period_idx = 0;
    _bufferFull = false;
}


void test_vector::releaseTimerBuffer()
{
//    free(_ptr_period_arr); /*free up the memory*/
    if( _ptr_period_arr != NULL)
    { 
        delete []_ptr_period_arr;
        _ptr_period_arr = NULL;
    }
}


bool test_vector:: getTimerBufferFull()
{
    return _bufferFull;
}

uint32_t test_vector::getTimerBufferSize()
{
    return _bufferSize;
} 

uint32_t* test_vector::getTimerBufferPointer()
{
    return _ptr_period_arr;
}

uint32_t test_vector::getPeriodIdx()
{
    return _period_idx;    
}

uint32_t test_vector::getCurrentTimerBufferValue()
{
    return *(_ptr_period_arr+_period_idx);
}
