#include "uart_mbed.h"
#include "mbed.h"
#include "scpi/scpi.h"


// Serial pc(USBTX, USBRX); // tx, rx

void uart_print(char *buffer){
    printf("RAM_ADDR:%02X MByte:%02X LByte:%02X'\n", *buffer, *(buffer+1),*(buffer+2));
}

void uart_read(char *buffer){
    gets(buffer);
}

void uart_write(char *buffer){
    printf(buffer);
}

void uart_start(){
    printf("data_start\n");
}

void uart_I2C_test_pass(){
    printf("i2c_test_pass, ready!\n");
}

void uart_I2C_test_fail(){
    printf("i2c_test_fail\n");
}

void uart_ram_dump_finish(){
    printf("dump_finish\n");
}

int SCPI_Error(scpi_t * context, int_fast16_t err) {
    (void) context;

    printf("**ERROR: %d, \"%s\"\r\n", (int32_t) err, SCPI_ErrorTranslate(err));
    return 0;
}

size_t SCPI_Write(scpi_t * context, const char * data, size_t len) {
    (void) context;
    return fwrite(data, 1, len, stdout);
}

scpi_result_t SCPI_Flush(scpi_t * context) {
    fflush(stdout);
    return SCPI_RES_OK;
}

/**
 * Return 0 as OK and other number as error
 */
scpi_result_t SCPI_Test(scpi_t * context) {
    printf("**Test\r\n");
    return (scpi_result_t)0;
}

extern "C" void mbed_reset();

scpi_result_t SCPI_Reset(scpi_t * context)
{
    mbed_reset();
    printf("**Reset\r\n");
    return SCPI_RES_OK;
}

scpi_result_t SCPI_Control(scpi_t * context, scpi_ctrl_name_t ctrl, scpi_reg_val_t val) {
    if (SCPI_CTRL_SRQ == ctrl) {
        printf("**SRQ: 0x%X (%d)\r\n", val, val);
    } else {
        printf("**CTRL %02x: 0x%X (%d)\r\n", ctrl, val, val);
    }
    return SCPI_RES_OK;
}


