#include "test_ehp_reg.h"
#include "main_init.h"
#include "mbed.h"

#define EHP_BUFF_SIZE 1001

test_ehp_reg::test_ehp_reg(PinName timerCapturePin, PinName adcCapturePin)
: test_vector(timerCapturePin, rise_fall, EHP_BUFF_SIZE), _interruptTrigger(adcCapturePin)
{}

void test_ehp_reg::_handleADCTriggerPinRiseIRQ() 
{
    
    _ADC_temp = _readADC();  /* sample ADC as quick as possible*/
    if(_ADC_idx <= EHP_BUFF_SIZE && !_ADCBufferFull) 
    {
        startTimer(); /*important! timer starts only the ADC trigger starts!!!!!! */
        if(_ADC_idx == getPeriodIdx())
        {
            _ADCperiodInSync = true;
            led4 = 1;
            _ptr_ADC_arr[_ADC_idx] = _ADC_temp;
            /* re-assemble last result together with last captured non-flat+period*/
             _ptr_ADC_arr[_ADC_idx-1] = _ptr_ADC_arr[_ADC_idx-1] + (getCurrentTimerBufferValue() << 16); /* test */
        }
        else
        {
            _ADCperiodInSync = false;
            led4 = 0;
        }
        _ADC_idx++;
        _ADCBufferFull = false;
        
    }
    else
    {
        _ADCBufferFull = true; 
        led4 = 0;  
    }
}

bool test_ehp_reg::_getADCBufferFull()
{
    return _ADCBufferFull;
} 


void test_ehp_reg::configure()
{
    /******************
    GPIO input to capture ADC.
    IO arrangement
    
    mbed_pin30 -> p0.4  -> ADC_OUT[0]
    mbed_pin29 -> p0.5  -> ADC_OUT[1]
    mbed_pin8  -> p0.6  -> ADC_OUT[2]
    mbed_pin7  -> p0.7  -> ADC_OUT[3]
    mbed_pin6  -> p0.8  -> ADC_OUT[4]
    mbed_pin5  -> p0.9  -> ADC_OUT[5]
    mbed_pin13 -> p0.15 -> ADC_OUT[6]
    mbed_pin14 -> p0.16 -> ADC_OUT[7]
    mbed_pin12 -> p0.17 -> ADC_OUT[8]
    mbed_pin11 -> p0.18 -> ADC_OUT[9]
    mbed_pin17 -> p0.25 -> ADC_OUT[10]
    mbed_pin18 -> p0.26 -> ADC_OUT[11]
    *******************/
    
    /****Set the port to GPIO***/
    /*p0.4 p0.5 p0.6 p0.7 p0.8 p0.9 p0.15*/
    LPC_PINCON->PINSEL0 &= ~( (3UL << 8 ) | (3UL << 10) | (3UL << 12) | (3UL << 14) |
                              (3UL << 16) | (3UL << 18) | (3UL << 30) ); 
    /*p0.16 p0.17 p0.18  p0.25 p0.26*/
    LPC_PINCON->PINSEL1 &= ~( (3UL << 0) | (3UL << 2) | (3UL << 4) |  (3UL << 18) | (3UL << 20) );
    
    /****Set the GPIO as input***/
    LPC_GPIO0->FIODIR &= ~( (1UL << 4)  | (1UL << 5)   | (1UL << 6)  | (1UL << 7)  |
                            (1UL << 8)  | (1UL << 9)   | (1UL << 15) | (1UL << 16) |
                            (1UL << 17) | (1UL << 18)  | (1UL << 25) | (1UL << 26) );
    
    _ptr_ADC_arr = new uint32_t[EHP_BUFF_SIZE]; 
    _ADC_idx = 0;
    _ADCBufferFull = false;
    _ADCperiodInSync = false;
    
    setUpTimerBuffer();
    configureTimer();
    
}


uint32_t test_ehp_reg::_readADC()
{

    uint32_t ioRead;
    uint32_t adcRead;
    ioRead = LPC_GPIO0->FIOPIN;
    adcRead =   ( ( ioRead & (1 << 4  ) ) >> 4  ) |
                ( ( ioRead & (1 << 5  ) ) >> 4  ) |
                ( ( ioRead & (1 << 6  ) ) >> 4  ) |
                ( ( ioRead & (1 << 7  ) ) >> 4  ) |
                ( ( ioRead & (1 << 8  ) ) >> 4  ) |
                ( ( ioRead & (1 << 9  ) ) >> 4  ) |
                ( ( ioRead & (1 << 15 ) ) >> 9  ) |
                ( ( ioRead & (1 << 16 ) ) >> 9  ) |
                ( ( ioRead & (1 << 17 ) ) >> 9  ) |
                ( ( ioRead & (1 << 18 ) ) >> 9  ) |
                ( ( ioRead & (1 << 25 ) ) >> 15 ) |
                ( ( ioRead & (1 << 26 ) ) >> 15 ) ;
    return adcRead;
} 

void test_ehp_reg::run() 
{
    _interruptTrigger.rise(callback(this, &test_ehp_reg::_handleADCTriggerPinRiseIRQ)); /* rising edge IRQ routine enbale*/
    while( (!_getADCBufferFull()) || (!getTimerBufferFull()))
    {
        ;
    }
}

void test_ehp_reg::stop() 
{
    stopTimer();
    _interruptTrigger.rise(NULL); /*disable pin interrupt*/
//    led4 = 0;   
}

void test_ehp_reg::release()
{
    releaseTimerBuffer();
    if( _ptr_ADC_arr != NULL)  
    {
        delete []_ptr_ADC_arr;
        _ptr_ADC_arr = NULL;
    }
}
    
uint32_t* test_ehp_reg::getResult()
{
//    return getTimerBufferPointer();
    return _ptr_ADC_arr;
    
}

uint32_t test_ehp_reg::getBufferSize()
{
    return EHP_BUFF_SIZE;
}

char* test_ehp_reg::getResultStatus() 
{
    return "Test PASS!!!";
}