#include "mbed.h"
#include "main_init.h"
#include "i2c_mbed_fpga.h"
#include "uart_mbed.h"
#include "scpi-def.h"

#define RAM_END_ADDR 0x4B
//#define HAVE_STDBOOL

i2c_mbed_fpga i2c;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3); 
DigitalOut led4(LED4);
DigitalOut fpga_rstb(p27);   //On FPGA PCB with red marked version ID it should be p20, (p27 of MBED is connected to p22 of the FPGA CMOD for 90415FPGA_EVB2)
//DigitalIn TimerIn(p29);  //p29 shall be input pin

/* Main function */
int main() {
    char i2cBuffer[3];
    char i2cTestPassFlag = 0;
//    char i2cRamDumpFlag = 0;
    char i2cTestPulseDebugFlag = 0;
    
    fpga_rstb = 1;
    configure_scpi(); 

    if(i2cTestPulseDebugFlag == 1) {
        i2c.i2c_mlx_mode_entry();
        wait_us(1000);
        *(i2cBuffer+0) = (char)(I2C_STATUS)& 0xff;
        i2c.i2c_word_read(i2cBuffer);
        uart_print(i2cBuffer);

        if( i2cBuffer[2] == 0x0C ){
            uart_I2C_test_pass();
            i2cTestPassFlag = 1;
            led4 = 0;
        }
        else {
            uart_I2C_test_fail();
            i2cTestPassFlag = 0;
            led4 = 1;
        }

        if(i2cTestPassFlag == 1){
            i2c.i2c_enable_pules_debug_mode(1);
            wait_us(1000);
        }
    }

    if(i2cTestPulseDebugFlag == 1) {
        wait_us(100000);
        char i;
        for(i=0xEA;i<=0xEF;i++) {
            *(i2cBuffer+0) = i;
            i2c.i2c_word_read(i2cBuffer);
            uart_print(i2cBuffer);
            wait_us(300000);
        }
        uart_ram_dump_finish();
    }
    /*enter infinite loop, motor should be running*/
    
    while (1) {
        char buffer[50];
        uart_read(buffer);
        strcat(buffer, "\n");
        SCPI_Input(&scpi_context, buffer, strlen(buffer));
    
    }

}