#ifndef TEST_VECTOR_H
#define TEST_VECTOR_H


//base abstract class for all test vectors

#include "mbed.h"

enum captureMode { rise_rise, rise_fall, fall_rise, fall_fall, both };

class test_vector {

public:
    test_vector(PinName pin, captureMode mode, uint32_t bufferSize);
    ~test_vector();
    virtual void configure()=0;
    virtual void run()=0;
    virtual void stop()=0;
    virtual uint32_t* getResult()=0;
    virtual char* getResultStatus()=0;
    virtual void release()=0;
    virtual uint32_t getBufferSize()=0;
    
    void configureTimer();
    void startTimer();
    void stopTimer();
    
    void setUpTimerBuffer();
    void releaseTimerBuffer();
    uint32_t getTimerBufferSize();
    uint32_t* getTimerBufferPointer();
    bool getTimerBufferFull();
    uint32_t getPeriodIdx();
    uint32_t getCurrentTimerBufferValue();
    
private:
    PinName _pinName;
    InterruptIn _interrupt;
    
    uint32_t _timer_value;
    uint32_t _period;
    uint32_t* _ptr_period_arr;
    uint32_t _period_idx;
    captureMode _mode;
    
    uint32_t _bufferSize;
    bool _bufferFull;
    void _handlePinRiseIRQ();
    void _handlePinFallIRQ();
    void _sampleCaptureTimer();
    void _savePeriod();     
};

#endif