#include "test_fg.h"
#include "main_init.h"
#include "mbed.h"

test_fg::test_fg(PinName pin): test_vector(pin, rise_rise, 1000)
{
    
}

void test_fg::configure()
{
    configureTimer();
    setUpTimerBuffer();
}

void test_fg::run() 
{
    startTimer();
    while(!getTimerBufferFull()){};
}

void test_fg::stop() 
{
    stopTimer();   
}

void test_fg::release()
{
    releaseTimerBuffer();
}

uint32_t* test_fg::getResult()
{
    return getTimerBufferPointer();
}


char* test_fg::getResultStatus() 
{
    return "Test PASS!!!";
}

uint32_t test_fg::getBufferSize()
{
    return 1000;
}
