#include "mbed.h"
#include "Motor.h"
RawSerial  pc(USBTX, USBRX);
RawSerial  dev(p13, p14);
DigitalOut led1(LED1);
DigitalOut led4(LED4);
AnalogIn   temp(p15);

Motor m(p23, p6, p5);

float _temp; 
float _speed = 0;
void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        char mode = dev.getc();
        if (mode == 'T') {
            _temp = temp;
            _temp = 38.0-27.5*_temp;
            dev.printf("%f\n",_temp);
 
        }
        if (mode=='V') {
            char type = dev.getc();
            if(type=='?') {
                dev.printf("%f\n",_speed);
            }  
            if(type=='+') {
                if (_speed < 1.0) {
                    _speed= _speed + 0.1;
                }
                m.speed(_speed);
                dev.printf("New Speed %f\n",_speed);
            } 
            if(type=='-') {
                if (_speed >= 0.1) _speed-= 0.1;
                m.speed(_speed);
                dev.printf("New Speed %f\n",_speed);
            }
        }
        
    }
}

void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}

int main()
{
    pc.baud(9600);
    dev.baud(9600);

    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);

    while(1) {
        sleep();
    }
}
