#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"
#include "TSISensor.h"
#include "USBHostMSD.h"


#define LED_ON  0 //outON, pwmON
#define LED_OFF 1 //outOFF,pwmOFF
#define PRESS_ON  0
#define PRESS_OFF 1

#define LED_PERIOD 150      //[ms]

#define MMA8451_I2C_ADDRESS (0x1d<<1)


struct KL46_SENSOR_DATA {
    int     sw1state;
    int     sw2state;
    float   accValX;
    float   accValY;
    float   accValZ;
    float   slider;
    float   light;
    int     magValX;
    int     magValY;
    int     magValZ;
} sensorData;


MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
DigitalOut gLED(LED_GREEN); //PTD5
PwmOut rLED(LED_RED);       //PTE29
DigitalIn  sw1(PTC3);  //if(sw1) Release else Press
DigitalIn  sw2(PTC12); //while(sw3); wait for Press

SLCD slcd; //[88:88][8.8.8.8] SegmentLCD
AnalogIn  light(PTE22); //analog-light input
TSISensor slider; //Capacitive Touch Slider
MAG3110 mag(PTE25, PTE24); //Magnetometer
Serial usb_osda(USBTX, USBRX); //OpenSDA Terminal



//Lab2add
void SLCD_blinking_msg_wait(char *slcd_msg1, char *slcd_msg2)
{
    char wait4sw1=0; //~500ms blinking
    slcd.CharPosition=0;
    //wait for Press SW1 - to start mag calibration
    while(sw1 == PRESS_ON); //wait for release
    while(sw1 == PRESS_OFF) { //wait for press
        if (++wait4sw1 < 150) //300ms
            slcd.printf(slcd_msg1);
        else //200ms
            slcd.printf(slcd_msg2);
        wait(0.002);
        slcd.CharPosition=0;
    }
    while(sw1 == PRESS_ON); //wait for release
}



int main(void)
{


    FILE *fp;


    sw1.mode(PullUp);
    sw2.mode(PullUp);
    
    gLED = LED_ON;
    rLED = LED_OFF;
    //rLED.period(LED_PERIOD);
    
    SLCD_blinking_msg_wait("   o","MSd ");//Lab1=Hid;2=cdc;3=Msd
    
    usb_osda.baud(115200);
    usb_osda.printf("\r\n Lab3: pls plug USB-stick into mUSB/KL46Z \r\n");
    
    slcd.printf("USb~"); //Lab1=Hid;2=cdc;3=Msd
    
    USBHostMSD msd("usb"); //wait for plugged USB-stick
    if (!msd.connect()) {
        error(" USB Flash drive not found.\r\n");
    }

    //Attempt to crete file /usb/usb_lab3.txt @USB-stick.
    fp = fopen("/usb/usb_lab3.txt", "w"); //rewrite, or create
    if (fp) {
        usb_osda.printf(" ... sucess file-open (/usb/usb_lab3.txt @USB-stick)!\r\n\r\n");
        fprintf(fp, " Lab3: from FRDM-KL46Z \r\n\r\n");
        fclose(fp); fp=NULL;
    } else usb_osda.printf(" ... failed file-open (/usb/usb_lab3.txt @USB-stick)!\r\n\r\n");


    while (1) {
        
        //disable all SLCD DPs
        slcd.DP(0, false); slcd.DP(1, false); slcd.DP(2, false);

        sensorData.accValX = acc.getAccX();
        sensorData.accValY = acc.getAccY();
        sensorData.accValZ = acc.getAccZ();
        sensorData.sw1state = sw1;
        sensorData.sw2state = sw2;
        
        sensorData.slider = slider.readPercentage() * 100;
        sensorData.light = light;
        sensorData.magValX = mag.readVal(MAG_OUT_X_MSB);
        sensorData.magValY = mag.readVal(MAG_OUT_Y_MSB);
        sensorData.magValZ = mag.readVal(MAG_OUT_Z_MSB);

         //sensor -> terminal
        if (fp) { gLED = !gLED; //blinkig
                usb_osda.printf("% 1.2f\r\n", sensorData.accValZ); //->terminal
                fprintf(fp,"% 1.2f\r\n", sensorData.accValZ); //->usb_file
        } else gLED = LED_OFF;

        if(!fp && sw1==PRESS_ON)  fp=fopen("/usb/usb_lab3.txt", "a");
        else
        if(fp && sw1==PRESS_OFF) {fclose(fp); fp=NULL; gLED=LED_OFF;}
        
        slcd.CharPosition=0; //prevent slcd rolling
        slcd.printf("% 3.0f", sensorData.accValZ);

        //rLED = abs(sensorData.accValZ);

        if (sensorData.slider) 
            slcd.printf(" %3.0f", sensorData.slider); //night->light .. 1->0
        else
            slcd.printf("%1.3f", sensorData.light); //left->right .. 0->100%

        wait(0.05);
    }   
}