#include "mbed.h"
#include "USBMouse.h"
#include "MMA8451Q.h"

#define LED_ON  0 //outON, pwmON
#define LED_OFF 1 //outOFF,pwmOFF
#define PRESS_ON  0
#define PRESS_OFF 1

#define LED_PERIOD 150      //[ms]

#define MMA8451_I2C_ADDRESS (0x1d<<1)


struct KL46_SENSOR_DATA {
    int     sw1state;
    int     sw2state;
    float   accValX;
    float   accValY;
    float   accValZ;
} sensorData;



int main(void)
{
    USBMouse mouse;
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    DigitalOut gLED(LED_GREEN); //PTD5
    PwmOut rLED(LED_RED);       //PTE29
    DigitalIn  sw1(PTC3);  //if(sw1) Release else Press
    DigitalIn  sw2(PTC12); //while(sw3); wait for Press

    sw1.mode(PullUp);
    sw2.mode(PullUp);
    
    gLED = LED_ON;
    rLED = LED_OFF;
    rLED.period(LED_PERIOD);
    
    while (1) {
        sensorData.accValX = acc.getAccX();
        sensorData.accValY = acc.getAccY();
        sensorData.accValZ = acc.getAccZ();
        sensorData.sw1state = sw1;
        sensorData.sw2state = sw2;
    
        
        rLED = abs(sensorData.accValZ);
        mouse.move(sensorData.accValX*16.0, sensorData.accValY*16.0);

        if(sensorData.sw1state == PRESS_ON) mouse.press(MOUSE_LEFT);
        else mouse.release(MOUSE_LEFT);

        if(sensorData.sw2state == PRESS_ON) mouse.press(MOUSE_RIGHT);
        else mouse.release(MOUSE_RIGHT);
        
        wait(0.05);
    }   
}