#include "mbed.h"
#include "USBJoystick.h"
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalIn sw2(SW2);
DigitalIn sw3(SW3);
Serial pc(USBTX, USBRX);

AnalogIn throt(A0);
AnalogIn yaw(A1);
AnalogIn pitch(A2);
AnalogIn roll(A3);

USBJoystick joystick;

int main() {
    int c;
    led_green = 1;
    led_red = 1;
    pc.baud(115200);
    pc.printf("Hello World from FRDM-K64F board.\n");

    while (true) {
        c += 1;
        joystick.update(
            throt.read() * 32767.0,
            yaw.read() * 32767.0,
            pitch.read() * 32767.0,
            roll.read() * 32767.0
        );

        led_red = 1;
        wait(0.005);
        //led_red = 0;
        //wait(0.01);
    }
}
