#ifndef HID_COMMAND_H
#define HID_COMMAND_H


/* Command Bytes                    */
/// system command byte
#define COMMAND_SYSTEM              0
/// SPI command byte
#define COMMAND_SPI                 1
/// Quadrature encoder command byte
#define COMMAND_QUADRATURE_ENCODER  2
/// Read GPI for Channel Y, DI2, DI3
#define COMMAND_READ_CHANNELS       3

/* System Command Data              */
#define SYSTEM_VERSION              0

/* System SPI Data                  */
//#define SPI_WRITE_READ              0

/* Version Information              */
/// USB protocol major version number
#define PROTOCOL_VERSION_MAJOR      0
/// USB protocol minor version number
#define PROTOCOL_VERSION_MINOR      1

/* Quadrature Encoder Data          */
#define QEI_SETUP                   0
#define QEI_POSITION                1
#define QEI_VELOCITY                2
#define QEI_POSITION_RESET          3

/* Quadrature Encoder Constants     */
#define QEI_VELOCITY_TIMER_US       100000
#define QEI_MAX_POSITION            1e6

/* Read GPIO */
#define READ_INPUT                  0
//
/* Function Prototypes              */
void setup_spi(void);
void command(HID_REPORT* in, HID_REPORT* out);
void command_system(HID_REPORT* in, HID_REPORT* out);
void command_spi(HID_REPORT* in, HID_REPORT* out);
void command_qei(HID_REPORT* in, HID_REPORT* out);
void command_read_channels(HID_REPORT* in, HID_REPORT* out);
#endif
