#include "mbed.h"
#include "USBHID.h"
#include "hid_command.h"

// USB Defines
/// Maxim USB VID
#define VID_MAXIM       0x0B6A
/// MAX14890E USB PID
#define PID_MAX14890E   0x3A2A
/// USB HID packet length
#define HID_PACKET_LEN  64

DigitalOut myled(LED1);

int main()
{
    
    HID_REPORT hidIn;
    HID_REPORT hidOut;

    USBHID hid (
        HID_PACKET_LEN, // output_report_length    Maximum length of a sent report (up to 64 bytes) (default: 64 bytes)
        HID_PACKET_LEN, // input_report_length Maximum length of a received report (up to 64 bytes) (default: 64 bytes)
        VID_MAXIM,      // vendor_id   Your vendor_id
        PID_MAX14890E,  // product_id  Your product_id
        1,              // product_release Your preoduct_release
        true            // connect Connect the device
    );

    hidOut.length = 64;
    for(int i=0; i<HID_PACKET_LEN; i++)
        hidOut.data[i] = 0x00;
        
    hidOut.data[0] = 0x00;
    hidOut.data[1] = 0x01;
    hidOut.data[2] = 0x02;
    hidOut.data[3] = 0x03;
    hidOut.data[4] = 0x04;
    hidOut.data[5] = 0x05;

    setup_spi();

    //hidIn.data[0] = COMMAND_QUADRATURE_ENCODER;
    //hidIn.data[1] = QEI_POSITION;
    
    while(1) {
        myled = 1;

        hid.read(&hidIn);
        command(&hidIn, &hidOut);
        hid.send(&hidOut);
        
        myled = 0;
    }
}
