/***********************************************************************
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/

// Tested with FRDM-K64F
#include "mbed.h"

#include "max14724.h"
#include "ard2pmod.h"

int main() {
    
    uint8_t data[4];
    
    Serial pc(USBTX, USBRX);
    pc.printf("\r\n\r\nMAX14724 Hello World!\r\n");
    
    Ard2Pmod a2p(Ard2Pmod::PMOD_TYPE_1_GPIO); // Configure ard2pmod multiplexer for GPIO (all switches open)
    a2p.set_switches((Ard2Pmod::SW11 | Ard2Pmod::SW09), (Ard2Pmod::SW13 | Ard2Pmod::SW10)); // Manually configure mux for custom I2C mapping
    a2p.rd_dir_registers(data); // Verify Ard2Pmod configuration with sucessful I2C read.
    pc.printf("Ad2Pmd mux data: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);
    
    Max14724 max14724(ARD2PMOD_SDA, ARD2PMOD_SCL, Max14724::MAX14724_I2C_ADRS1);
    
    //wait(2); // turn on delay
    
    // Write MAX14724 Switches Indirectly    
    max14724.rd_dir_registers(data);
    pc.printf("DIR Registers: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);
    
    max14724.wrt_shadow_registers(Max14724::SW01, Max14724::SW02, Max14724::SW03, Max14724::SW04);
    pc.printf("Write Shadow Registers\r\n");
    
    max14724.rd_dir_registers(data);
    pc.printf("DIR Registers: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);
    
    max14724.rd_shadow_registers(data);
    pc.printf("Shadow Registers: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);
    
    max14724.wrt_cmd_registers(Max14724::COPY_SHADOW, Max14724::COPY_SHADOW, Max14724::COPY_SHADOW, Max14724::COPY_SHADOW);
    pc.printf("Write Command Registers\r\n");
    
    max14724.rd_dir_registers(data);
    pc.printf("DIR Registers: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);
    
    max14724.rd_shadow_registers(data);
    pc.printf("Shadow Registers: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);    
    
    // Write MAX14724 Switches Directly
    max14724.set_switches(Max14724::SW05, Max14724::SW06, Max14724::SW07, Max14724::SW08);
    pc.printf("Set Switches Directly\r\n");
    
    max14724.rd_dir_registers(data);
    pc.printf("DIR Registers: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);
    
    max14724.rd_shadow_registers(data);
    pc.printf("Shadow Registers: 0x%02X 0x%02X 0x%02X 0x%02X\r\n", data[0], data[1], data[2], data[3]);   
    
    return 0;
}
