//-----------------------------------------------------------
//
//  F746_SLIDER class
//
//-----------------------------------------------------------

#include "F746_SLIDER.hpp"

extern uint16_t SliderDisplayValue_;

// Draw Slider
void Slider::Render()
    {
        active_ = true;
        char min_[3];               //string Slider minimum;
        char max_[3];               //string Slider maximum;
        
        switch(STYLE_)
            {
                case 1:                                     // Style 1 - Normal Slider         
                    lcd_.SetTextColor(SLIDER_COLOUR_);                  // Slider rectangle
                    lcd_.FillRect(SliderX_, SliderY_, SliderW_, 40);
                    lcd_.SetTextColor(LCD_COLOR_GRAY);                  // Slider Control rectangle
                    uint16_t xC = (SliderW_/(Max_-Min_)* valueControl_);          // Calculate initial value of Slider control
                    lcd_.FillRect(SliderX_+xC-20, SliderY_, 40, 40);
                    break;
        
                case 2:                                     // Style 2 - 3D Slider
                    lcd_.SetTextColor(LCD_COLOR_DARKGRAY);  // Set Textcolour to shadow colour
                    lcd_.FillRect(SliderX_+2, SliderY_+2, SliderW_+3, 40+3);    // Draws shadow                
                    lcd_.SetTextColor(SLIDER_COLOUR_);                          // Slider rectangle
                    lcd_.FillRect(SliderX_, SliderY_, SliderW_, 40);
                    lcd_.SetTextColor(LCD_COLOR_GRAY);                          // Slider Control rectangle
                    xC = (SliderW_/(Max_-Min_)* valueControl_);                           // Calculate initial value of Slider control
                    lcd_.FillRect(SliderX_+xC-20, SliderY_, 40, 40);
                    break; 
            }          
     
        if (LABEL_.length() != 0)
            {
                lcd_.SetFont(FONTS_);
                lcd_.SetBackColor(LCD_COLOR_WHITE);
                lcd_.SetTextColor(LCD_COLOR_BLACK);
                        
                sprintf(min_, "%2d", (int) Min_);           // Convert minimum value to string
                lcd_.DisplayStringAt(SliderX_, SliderY_+50, (uint8_t *)min_, LEFT_MODE);  // Display Slider minimum value

                sprintf(max_, "%2d", (int) Max_);           // Convert maximum value to string
                lcd_.DisplayStringAt((SliderX_+SliderW_-40), (SliderY_+50), (uint8_t *)max_, LEFT_MODE);  // Display Slider minimum value                        

                uint16_t x0 = SliderX_ + (SliderW_ - FONT_WIDTH_*(LABEL_.length()))/2;      // Calcukate middle x value for Slider name
                uint16_t y0 = SliderY_ + (SliderH_ - FONT_HEIGHT_)/2 + 1;                   // Calcukate y value for Slider name
                lcd_.DisplayStringAt(x0, y0-50, (uint8_t *)LABEL_.c_str(),    
                                 LEFT_MODE);                                        // Write Slider name
            }        
    }
    
        
// Service Slider
void Slider::Service()
    {  
        uint16_t xC_;           // X value of Control rectangle
        uint16_t valueControl_; // Value of Slider control to display
        
        switch(STYLE_)
            {
                case 1:                                     // Style 1 - Normal button 
                lcd_.SetTextColor(SLIDER_COLOUR_);          // Draw Slider rectangle
                lcd_.FillRect(SliderX_, SliderY_, SliderW_, 40);
                break;
        
                case 2:                                                     // Style 2 - 3D button
                    lcd_.SetTextColor(LCD_COLOR_DARKGRAY);                  // Set Textcolour to shadow colour
                    lcd_.FillRect(SliderX_+2, SliderY_+2, SliderW_+3, 40+3);// Draws shadow                
                    lcd_.SetTextColor(SLIDER_COLOUR_);                      // Slider rectangle
                    lcd_.FillRect(SliderX_, SliderY_, SliderW_, 40);
                    lcd_.SetTextColor(LCD_COLOR_GRAY);                      // Slider Control rectangle
                    break; 
            }

        uint16_t newX = state_.touchX[0];                       // Find new x value of touch
             
        if ((newX >= SliderX_) and (newX <= SliderX_+ 40))      // if touch at beginning of Slider
            {
                    {   xC_ = SliderX_;   }                     // Sets x value of Slider control to left x value defined for slider rectangle
            }
                            
        else if ((newX >= SliderX_+SliderW_-40) and (newX <= SliderX_+ SliderW_))   // if touch at the end of Slider
            {
                xC_ = SliderX_+SliderW_-40;                     // Sets x value of Slider control to right x value defined for slider rectangle - width of slider control
            }
                            
        else xC_ = newX - 20;                       // if touch inside Slider    
                       
        lcd_.SetTextColor(LCD_COLOR_YELLOW);        // Colour to change the control of the Slider when touched    
        lcd_.FillRect(xC_, SliderY_, 40, 40);
                        
        valueControl_ = (newX - SliderX_) * (Max_ - Min_) / SliderW_ + Min_;      // Value to display of the control of the Slider
        if (valueControl_== (Min_+1))valueControl_= Min_;               // Set value value to display to minimum
        if (valueControl_== (Max_-1))valueControl_= Max_;               // Set value value to display to maximum                                              
                        
                        
        lcd_.SetTextColor(LCD_COLOR_BLACK);    
        SliderDisplayValue_ = valueControl_;
        lcd_.SetTextColor(LCD_COLOR_YELLOW);       
    } 


        
bool Slider::Moved()          // Check touch detected
    {
        ts_.GetState(&state_);  // Get state of touch
        if (!state_.touchDetected) return false;
        if (!active_) return false;
        if (!SliderBoundaryCheck()) return false;
        Service();              // Run Service routine
        return SliderBoundaryCheck();
    }
 

bool Slider::SliderBoundaryCheck()       // Check if touch is within Slider boundaries
    {
        int nTouch = multiTouch ? state_.touchDetected : 1;
        for (int n=0; n<nTouch; n++)
        {
            uint16_t x = state_.touchX[n];                  // Find x value of touch
            uint16_t y = state_.touchY[n];                  // Find y value of touch

            if ( (SliderX_ <= x) && (x <= SliderX_+SliderW_) &&               
                 (SliderY_ <= y) && (y <= SliderY_+SliderH_) ) return true;   // Check if touch is within Slider defined values
        }
        return false;
    }
 
TS_StateTypeDef Slider::state_;
bool Slider::multiTouch = false;    // Disable multitouch for Slider

