//---------------------------------------------------------------
//
//  Demo program for 
//  F746_Button and Slider library
//
//---------------------------------------------------------------
#include "mbed.h"
#include "F746_BUTTON.hpp"
#include "F746_SLIDER.hpp"

TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;


char char_SliderDisplayValue[4];    // String Value to display for the Slider Control value 
uint16_t SliderDisplayValue_;       // Variable used to access Slider Control Value in F746SLIDER.cpp

int main()
{
    lcd_.Clear(LCD_COLOR_WHITE);                                        // Set LCD Background colour
   
    Slider sld1(lcd_, ts_, 20, 205, 150, 20, 5, 1, 20,     
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 1, "Slider1", Font12);   // Define sld1 slider            
    sld1.Render();                                                          // Draw sld1 Slider  
   
    Slider Slider2(lcd_, ts_, 240, 205, 220, 20, 50, 1, 100,        
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Slider2", Font12);   // Define Slider2 slider            
    Slider2.Render();                                                       // Draw Slider2 Slider      
       
    Button btn1(lcd_, ts_, 20, 50, 80, 40,           
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 1, "BUTTON1", Font12);  // Define btn1 button            
    btn1.Render();                                                         // Draw btn1 button
    
    Button test(lcd_, ts_, 120, 50, 80, 40,
                 LCD_COLOR_DARKBLUE, LCD_COLOR_GREEN, 1, "TEST", Font12);  // Define test button                   
    test.Render();                                                         // Draw test button
    
    Button show(lcd_, ts_, 220, 50, 80, 40,            
                 LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1,  "SHOW", Font12);     // Define hide button            
    show.Hide();  
    
    Button hide(lcd_, ts_, 220, 50, 80, 40,            
                 LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1,  "HIDE", Font12);     // Define hide button             
    hide.Render();                                                         // Draw hide button
    
    Button button3D(lcd_, ts_, 320, 50, 120, 40,             
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "3D BUTTON", Font12);    // Define button3D button            
    button3D.Render();                                                         // Draw 3Dbutton button

    lcd_.SetTextColor(LCD_COLOR_BLACK);                                                         // Set Text colour to Black
    lcd_.SetFont(&Font12);                                                                      // Font size 12
    lcd_.DisplayStringAt(5, 5, (uint8_t *)"Button / Slider driver for DISCO_F746", LEFT_MODE);  // Display main header text
    lcd_.DisplayStringAt(5, 20, (uint8_t *)"Button example", LEFT_MODE);  // Display secondary header text
    lcd_.DisplayStringAt(5, 135, (uint8_t *)"Slider example", LEFT_MODE);  // Display secondary header text

    while (true)                                                    // Main program loop
    {
        if (sld1.Moved())                                           // Check if sld1 Slider was touched and run instructions if true
        {    
            lcd_.SetTextColor(LCD_COLOR_BLACK);                     
            lcd_.FillRect(130, 140, 80, 40);                         // Draw border to display Slider Control Value
            lcd_.SetTextColor(LCD_COLOR_WHITE);
            lcd_.FillRect(140, 145, 60, 30);                         // Draw border to display Slider Control Value                                     
            
            sprintf(char_SliderDisplayValue, "%3d", (int) SliderDisplayValue_);                     // Convert integer to text
            lcd_.SetFont(&Font12);                                                                  // Set Font size
            lcd_.SetTextColor(LCD_COLOR_BLACK);                                                     // Set Font colour
            lcd_.DisplayStringAt(150, 155, (uint8_t *)char_SliderDisplayValue, LEFT_MODE);          // Write Slider Control Value to the LCD
            
            if (SliderDisplayValue_ < 10)                                                           // Slider Control Value decision
                {
                    lcd_.DisplayStringAt(60, 190, (uint8_t *)"                     ", LEFT_MODE);   // Overwrite previous text
                    lcd_.DisplayStringAt(60, 190, (uint8_t *)"SLIDER1 < 50%", LEFT_MODE);           // Write text to LCD
                }
            else if (SliderDisplayValue_ == 10)                                                     // Slider Control Value decision
                {  
                    lcd_.DisplayStringAt(60, 190, (uint8_t *)"                     ", LEFT_MODE);   // Overwrite previous text
                    lcd_.DisplayStringAt(60, 190, (uint8_t *)"SLIDER1 = 50%", LEFT_MODE);           // Write text to LCD
                }
            else                                                                                    // Slider Control Value decision
                {  
                    lcd_.DisplayStringAt(60, 190, (uint8_t *)"                     ", LEFT_MODE);   // Overwrite previous text
                    lcd_.DisplayStringAt(60, 190, (uint8_t *)"SLIDER1 > 50%", LEFT_MODE);           // Write text to LCD
                }          
        }                                                                                           // End sld1 instructions

        if (Slider2.Moved())                                      // Check if Slider2 Slider was touched and run instructions if true
        {    
            lcd_.SetTextColor(LCD_COLOR_BLACK);                     
            lcd_.FillRect(390, 140, 80, 40);                         // Draw border to display Slider Control Value
            lcd_.SetTextColor(LCD_COLOR_WHITE);
            lcd_.FillRect(400, 145, 60, 30);                         // Draw border to display Slider Control Value                                     
            
            sprintf(char_SliderDisplayValue, "%3d", (int) SliderDisplayValue_);                     // Convert integer to text
            lcd_.SetFont(&Font12);                                                                  // Set Font size
            lcd_.SetTextColor(LCD_COLOR_BLACK);                                                     // Set Font colour
            lcd_.DisplayStringAt(415, 155, (uint8_t *)char_SliderDisplayValue, LEFT_MODE);          // Write Slider Control Value to the LCD
        }    
    
    
        if (btn1.Press())                                         // Check if btn1 button was touched and run instructions if true
        {    
            lcd_.SetFont(&Font12);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"Button1 pressed", LEFT_MODE);
            wait(0.5); 
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"                                        ", LEFT_MODE);
        }                                                           // End btn1 button instructions
        
        if (test.Press())                                         // Check if test button was touched and run instructions if true
        {
            lcd_.SetFont(&Font12);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"TEST pressed", LEFT_MODE);
            wait(0.5);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"                                        ", LEFT_MODE);
            
        }                                                           // End test button instructions
        
        if (hide.Press())                                         // Check if hide button was touched and run instructions if true
        {    
            lcd_.SetFont(&Font12);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"Hide pressed - Hide other buttons", LEFT_MODE);
            btn1.Hide();                                            // Hide btn1 button
            test.Hide();                                            // Hide test button
            hide.Hide();  
            show.Render();
            wait(0.5);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"                                        ", LEFT_MODE);
        }                                                           // End hide button instructions
        
         if (show.Press())                                        // Check if hide button was touched and run instructions if true
        {  
            lcd_.SetFont(&Font12);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"UNHIDE pressed - Restore other buttons", LEFT_MODE);
            wait(0.5);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"                                        ", LEFT_MODE);
            show.Hide();                                            // Hide show button before drawing new button in same place
            hide.Render();                                            // Draw hide button after hiding button in same position
            btn1.Render();                                            // Draw btn1 button
            test.Render();                                            // Draw test button
            
        }         
        
        if (button3D.Press())                                     // Check if 3Dbutton button was touched and run instructions if true
        {    
            lcd_.SetFont(&Font12);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"3D Button pressed", LEFT_MODE);
            wait(0.5);
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"                                           ", LEFT_MODE);
        }                                                           // End 3D button instructions
 
        wait(0.02f);   
    }                                                               // End Main program loop
}                                                                   // End Main program 
