#include "mbed.h"
#include "beep.h"
Beep buzzer(p23);

DigitalOut myled(LED1);

void play(char* note, char* length);

void tetris() {

   
    play("g", "Q");
    play("d", "E");
    play("eb", "E");
    play("f", "Q");
    play("eb", "E");
    play("d", "E");
    play("c", "Q");
    play("c", "E");
    play("eb", "E");
    play("g", "Q");
    play("f", "E");
    play("eb", "E");
    play("d", "T");
    play("eb", "E");
    play("f", "Q");
    play("g", "Q");
    play("eb", "S");
    play("c", "S");
    play("c", "S");
    play("r", "Q");
    play("r", "E");
    play("f", "T");
    play("abh", "E");
    play("ch", "Q");
    play("bbh", "E");
    play("abh", "E");
    play("g", "T");
    play("eb", "E");
    play("g", "Q");
    play("f", "E");
    play("eb", "E");
    play("d", "Q");
    play("d", "E");
    play("eb", "E");
    play("f", "Q");
    play("g", "Q");
    play("eb", "Q");
    play("c", "S");
    play("c", "S");
    play("r", "Q");

}


void play(char* note, char* length) {
    
    if (note=="ab") {
        buzzer.beepFreq(830);
    }
    if (note=="abh"){
    buzzer.beepFreq(1661);
    }
    if (note=="bb") {
        buzzer.beepFreq(932);
    }
    if (note=="bbh") {
        buzzer.beepFreq(1865);
    }
    if (note=="c") {
        buzzer.beepFreq(1046);
    }
    if (note=="ch") {
        buzzer.beepFreq(2093);
    }
    if (note=="d") {
        buzzer.beepFreq(1175);
    }
    if (note=="eb") {
        buzzer.beepFreq(1245);
    }
    if (note=="f") {
        buzzer.beepFreq(1397);
    }
    if (note=="g") {
        buzzer.beepFreq(1568);
    }
    if (note=="r") {
        buzzer.beepFreq(0);
    }
    
    if (length=="Q"){ //quarter note
        buzzer.beepTime(0.5);
        wait (0.5);
    }
    if (length=="E"){ // eighth note
        buzzer.beepTime(0.25);
        wait(0.25);
    }
    if (length=="T"){ //quarter+eigthh note
        buzzer.beepTime(0.75);
        wait(0.75);
    }
    if (length=="S"){ //staccato note
    buzzer.beepTime(0.25);
    wait(0.5);
    }

}


int main() {
    tetris();
}
