#include "mbed.h"
#include "rtos.h"
#include "LSM9DS1.h"
#define DECLINATION -4.94
#define PI 3.14159
#include "Motor.h"


// Timer example: https://developer.mbed.org/handbook/Timer
AnalogIn infraredR(p20); //Right infrared distance sensor
AnalogIn infraredL(p19); //Left infrared distance sensor
AnalogIn infraredF(p17); //Front infrared distance sensor
Serial pc(USBTX, USBRX);
Timer t;
char str[60];                           //buffer for xbee messages
float maxspeed = 0.4;
float minspeed = -0.4;
float leftDist, rightDist, frontDist;   //Distances from robot to obstacles
float xaccel, yaccel, zaccel;           //Acceleration in the x, y, and z directions
float xmag, ymag, zmag, head;           //Magnetic readings
int ldist, rdist, fdist;                
Serial xbee(p28,p27);                   //xbee over serial
Mutex stdio_mutex;
float heading;
//dual H bridge Polulu
Motor MotorRi(p21, p23, p24);
Motor MotorLe(p22, p26, p25);
float ti = 0, timelast = 0, deltat;

float imu[] = {0, 0, 0};
float velX[] = {0, 0, 0};
float velY[] = {0, 0, 0};
float posX[] = {0, 0, 0};
float posY[] = {0, 0, 0};
float compass[] = {0, 0, 0};

void printAttitude(float ax, float ay, float az, float mx, float my, float mz)
{
    float roll = atan2(ay, az);
    float pitch = atan2(-ax, sqrt(ay * ay + az * az));
// touchy trig stuff to use arctan to get compass heading (scale is 0..360)
    mx = -mx;
    if (my == 0.0)
        heading = (mx < 0.0) ? 180.0 : 0.0;
    else
        heading = atan2(mx, my)*360.0/(2.0*PI);
    //pc.printf("heading atan=%f \n\r",heading);
    heading -= DECLINATION; //correct for geo location
    if(heading>180.0) heading = heading - 360.0;
    else if(heading<-180.0) heading = 360.0 + heading;
    else if(heading<0.0) heading = 360.0  + heading;


    // Convert everything from radians to degrees:
    //heading *= 180.0 / PI;
    pitch *= 180.0 / PI;
    roll  *= 180.0 / PI;

    //pc.printf("Pitch: %f,    Roll: %f degress\n\r",pitch,roll);
    //pc.printf("Magnetic Heading: %f degress\n\r",heading);
    head = heading * PI / 180.0;
}

void shiftArrays() {
    int i;
    for (i = 2; i > 0; i--) {
        posX[i] = posX[i - 1];
        posY[i] = posY[i - 1];
        velX[i] = velX[i - 1];
        velY[i] = velY[i - 1];
        imu[i] = imu[i - 1];
        compass[i] = compass[i-1];
    }
}

void IMU_thread(void const *args) {
    LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
    IMU.begin();
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
    //pc.printf("calibrated accel, now do mag\r\n");
    IMU.calibrateMag(0);
    //pc.printf("calibrated mag\r\n");
    while(1) {
        //pc.printf("check accelAvailable\r\n");
        while(!IMU.accelAvailable());
        //pc.printf("got accel\r\n");
        IMU.readAccel();
        while(!IMU.magAvailable(X_AXIS));
        //pc.printf("got mag\r\n");
        IMU.readMag();
        xaccel = IMU.calcAccel(IMU.ax);
        if (abs(xaccel) < 0.13)
            xaccel = 0.0;
        yaccel = IMU.calcAccel(IMU.ay);
        if (abs(yaccel) < 0.13)
            yaccel = 0.0;
        zaccel = IMU.calcAccel(IMU.az);
        if (abs(zaccel) < 0.13)
            zaccel = 0.0;
        //pc.printf("%f\r\n",zaccel);
        xmag = IMU.calcMag(IMU.mx);
        ymag = IMU.calcMag(IMU.my);
        zmag = IMU.calcMag(IMU.mz);
        printAttitude(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), IMU.calcMag(IMU.mx), IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
        
       // Thread::wait(50); //Wait 
    }    
}
/*
void pos_thread(void const *args) {
    while(1) {
        
        shiftArrays();
        imu[0] = xaccel;

        velX[0] += imu[0]*cos(compass[0])  * deltat;
        velY[0] += imu[0]*sin(compass[0])  * deltat;
        posX[0] += velX[0] * .1;
        posY[0] += velY[0] * .1;  
        wait(.1);  
    }    
}    */
void left_thread(void const *args) {
    while (1) {
        leftDist = infraredL * 80.0f;  
        leftDist = 80.0f - leftDist;
        ldist = (int)leftDist;
        Thread::wait(500);     //wait 1/2 second before updating
        }
}

void right_thread(void const *args) {
    while (1) {
        rightDist = infraredR * 80.0f;
        rightDist = 80.0f - rightDist;
        rdist = (int)rightDist;
        Thread::wait(500);     //wait 1/2 second before updating
        }
}

void front_thread(void const *args) {
    while (1) {
        frontDist = infraredF * 80.0f;
        frontDist = 80.0f - frontDist;
        fdist = (int)frontDist;
        Thread::wait(500);     //wait 1/2 second before updating
        }
}    

void send_thread(void const *args) {
    xbee.baud(9600);
    while (1) {
        ti = t.read();
        deltat = ti-timelast;
        stdio_mutex.lock();
        sprintf (str, "%0.6f,%0.6f,%0.6f,%d,%d,%d,%0.6f\n", posX[0], posY[0], heading, fdist, ldist, rdist, deltat);   //buffer data to be sent to computer
//        pc.printf("%0.6f,%0.6f,%0.6f\r\n",xaccel,yaccel,deltat);
        pc.printf(str);
//        pc.printf("%0.6f\r\n", zmag*9.8);
        xbee.printf(str);
        stdio_mutex.unlock();
        timelast = ti;
        Thread::wait(500);
    }
}        

void motor_thread(void const *args) {
    Thread::wait(5000);        //allow gyro and accel to calibrate on level surface
    MotorRi.speed(0.4);
    MotorLe.speed(-0.4);
    Thread::wait(3000);         //allow mag to calibrate by spinning
    MotorRi.speed(0.0);
    MotorLe.speed(-0.0);
    Thread::wait(10000);
    while(1) {
        if (fdist > 40) {                   //if there's room to go forward
            posX[0] += cos(head) * 0.0001;
            posY[0] += sin(head) * 0.0001;
            if (ldist < 20) {
                MotorRi.speed(0.1);
                MotorLe.speed(0.3);
                Thread::wait(40);
            }
            else if (rdist < 20) {
                MotorRi.speed(0.3);
                MotorLe.speed(0.1);
                Thread::wait(40);
            }
            else {
                MotorRi.speed(0.3);
                MotorLe.speed(0.3);
            }
        }    
        else if (rdist < ldist) {               //hard turn to the left
            MotorRi.speed(0.3);
            MotorLe.speed(-0.3); 
            Thread::wait(500);         
        }
        else if (ldist < rdist) {               //hard turn to the right
            MotorRi.speed(-0.4);
            MotorLe.speed(0.4);   
            Thread::wait(500);        
        }
    }
}        

int main() {
    //Test
    t.start();
    //Thread posi(pos_thread);
    Thread left(left_thread);
    Thread right(right_thread);
    Thread front(front_thread);
    Thread IMU(IMU_thread);
    Thread Mot(motor_thread);
    Thread send(send_thread);
    while(1){  
         //do stuff 
        }
}
