#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "USBHostMSD.h"
#include "wave_player.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); 
Serial pc(USBTX, USBRX);
Mutex ulcd_mutex;
uLCD_4DGL uLCD(p9,p10,p19); // serial tx, serial rx, reset pin;
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

DigitalOut latch(p15);
DigitalOut enable(p17);
//Analog Out Jack
AnalogOut DACout(p18);
//On Board Speaker
PwmOut PWMout(p26);
SPI spi(p11, p12, p13);
wave_player waver(&DACout,&PWMout);
int playing = 1;
int red=0;
int green=0;
int blue=0;
int play = 0;

void ulcd2_thread(void const *args) {
    int count = 0;
    while(true) {
        ulcd_mutex.lock();
        pc.printf("Activated mutex lock on uLCD screen: ulcd2_thread\n\r");
        uLCD.cls();
        uLCD.printf("\nECE 4180 L3: RTOS\n"); //Default Green on black text
        uLCD.printf("\nWes Schon Nick Liu");
        uLCD.printf("\n\nThread 2 count: %d", count);
        if (playing == 1)
            uLCD.printf("\n\nPlaying wav file...");
        else
            uLCD.printf("\n\nWav file finished.");    
        uLCD.text_width(4); //4X size text
        uLCD.text_height(4);
        Thread::wait(3000);
        ulcd_mutex.unlock();
        count++;
        }
    }
void wav_thread(void const *args) {
    while(1) {
        if (play == 1) {
            //USBHostMSD msd("usb");
            //pc.printf("\nset up usb host\n");
            myled = !myled;
            FILE *wave_file;
            //pc.printf("\nread wav file\n");
            //setup PWM hardware for a Class D style audio output
            PWMout.period(1.0/400000.0);
            //printf("\n\n\nHello, wave world!\n");
            // wait until connected to a USB device
            //while(!msd.connect()) {
            //    Thread::wait(500);
            //}
            //open wav file and play it
            wave_file=fopen("/sd/monkey4.wav","r");
    
            //pc.printf("\nplay\n");
            playing = 1;
            waver.play(wave_file);
            myled2 = !myled2;
            pc.printf("\nclose\n");
            fclose(wave_file);
            playing = 0;
            myled3 = !myled3;
            //end of program
            Thread::wait(500);
            myled4 = !myled4;
            
            }
        }
    }

void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}


void led_thread(void const *args) {

    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    Thread::wait(2000);
    while(1) {
    if (play == 1) {
        red = 0;
        green = 50;
        blue = 0;
        RGB_LED( red, green, blue);
        Thread::wait(250);
        }
    else {
        red = 0;
        green = 0;
        blue = 50;
        RGB_LED( red, green, blue);
        Thread::wait(250);
        red = 50;
        green = 0;
        blue = 0;
        RGB_LED( red, green, blue);
        Thread::wait(250);
        }
    }
    }


int main() {
    Thread thread(ulcd2_thread);
    pc.printf("\nwav_thread\n");
    Thread thread2(wav_thread);
    pc.printf("\nend wav_thread\n");
    Thread thread3(led_thread);
    int count2 = 0;
    while(1) {
        myled = 1;
        Thread::wait(200);
        myled = 0;
        Thread::wait(200);
        ulcd_mutex.lock();
        uLCD.cls();
    //SD card needed with image and video files for last two demos
        uLCD.cls();
        uLCD.media_init();
        uLCD.printf("\n\nThread 1 count: %d", count2);
        if (playing == 1)
            uLCD.printf("\n\nPlaying wav file...");
        else
            uLCD.printf("\n\nWav file finished.");  
        Thread::wait(200);
        play = 1;
        uLCD.set_sector_address(0x0000, 0x0000);
        uLCD.display_video(0,0);
        Thread::wait(100);
        ulcd_mutex.unlock();
        play = 0;
        count2++;
    }
}
