#include "mbed.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

PwmOut myled(p21);
DigitalIn button1(p30);
DigitalIn button2(p29);
DigitalIn switch1(p8);
DigitalOut myled4(LED4);
DigitalOut myled3(LED3);
float intensity = 0.5f;

// Function to power down magic USB interface chip with new firmware
#define USR_POWERDOWN    (0x104)
int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
// Setup the watchdog timer
Watchdog wdt;


int main() {
    PHY_PowerDown();   //Power down Ethernet interface
    int result;
    result = semihost_powerdown();  //Power down USB interface
    int count = 0;
    Peripheral_PowerDown(0xFFFF7FFF);

    wdt.kick(4.0);
    if ((LPC_WDT->WDMOD >> 2) & 1)
        myled4 = 1; else myled3 = 1;
        wait(2);
        myled4 = 0;
        myled3 = 0;

     
    
    while(1) {
        if (button1 == 0)  {
            if (intensity <= 1.0f) {
                intensity += 0.07f;
            }
        }
        if (button2 == 0) {
            if (intensity >= 0.0f) {
                intensity -= 0.07f;
            }
        }
        if (switch1 == 0) {
            myled = intensity;
        }
        else {
            myled = 0.0f;
            }
        wait(0.1);
        count++;
        if (count == 80) {
            wait(11);
            }
        wdt.kick(); //kick the watchdog timer
    }
}
