#include "mbed.h"
#include <string>
#include "VFD.h"

VFD::VFD() : _i2c(SDA, SCL) {
    _i2c.frequency(100000);
}

VFD::~VFD() {
    //Nothing to see here
}

void VFD::start() {
    _i2c.start();
}

void VFD::stop() {
    _i2c.stop();
}

int VFD::send_byte(int byte) {
    return _i2c.write(byte);
}

int VFD::read_byte(int ack) {
    return _i2c.read(ack);
}

int VFD::init() {
    const char cmd[] = {254,160,0};
    int length = 3;
    return write(cmd, length);
}

int VFD::print(string  msg) {
    return write(msg.data(), msg.size());
}

int VFD::autoScrollOn() {
    const char cmd[] = {254, 81};
    int length = 2;
    return write(cmd, length);
}

int VFD::autoScrollOff() {
    const char cmd[] = {254, 82};
    int length = 2;
    return write(cmd, length);
}

int VFD::lineWrapOn() {
    const char cmd[] = {254, 67};
    int length = 2;
    return write(cmd, length);
}

int VFD::lineWrapOff() {
    const char cmd[] = {254, 68};
    int length = 2;
    return write(cmd, length);
}

int VFD::setCursor(const int col, const int row) {
    const char cmd[] = {254, 71, col, row};
    int length = 4;
    return write(cmd, length);
}

int VFD::clearScreen() {
    const char cmd[] = {254, 88};
    int length = 2;
    return write(cmd, length);
}

int VFD::goHome() {
    const char cmd[] = {254, 72};
    int length = 2;
    return write(cmd, length);
}

int VFD::initLargeNumbers() {
    const char cmd[] = {254, 110};
    int length = 2;
    return write(cmd, length);
}

int VFD::setBrightness(const int val) {
    if (val < 0 || val > 3)
        return -1;
    const char cmd[] = {254, 89, val};
    int length = 3;
    return write(cmd, length);
}

int VFD::write(const char * data, int length) {
    int ret = _i2c.write(address, data, length); //Performs a complete write transaction
    wait_us(625);
    return ret; //Return I2C.write(...) return value
}

int VFD::read(char * data, int length) {
    int ret = _i2c.read(address, data, length); //Performs a complete write transaction
    wait_us(625);
    return ret; //Return I2C.write(...) return value
}