/*
 * File: VfD/VFD.h
 * Author: William Jessup Salisbury
 * Company: Tufts Hybrid Racing Team
 * Copyright: CC BY-NC-SA 3.0
 * Date: 3/11/2012
 */

#ifndef VFD_H
#define VFD_H

#include "mbed.h"
#include <string>

const PinName SDA = p28;
const PinName SCL = p27;
const int address = 0x50;

class VFD {
public:
    VFD();
    ~VFD();
    void start(void);
    void stop(void);
    int send_byte(int byte);
    int read_byte(int ack);
    int init();
    int print(const string msg);
    int autoScrollOn();
    int autoScrollOff();
    int lineWrapOn();
    int lineWrapOff();
    int setCursor(const int col, const int row);
    int clearScreen();
    int goHome();
    int initLargeNumbers();
    int setBrightness(const int val);
private:
    I2C _i2c;
    int write(const char * data, int length);
    int read(char * data, int length);
};

#endif
