/*
 * File: SensorNode/SensorNode.h
 * Author: William Jessup Salisbury
 * Company: Tufts Hybrid Racing Team
 * Copyright: CC BY-NC-SA 3.0
 * Date: 1/12/2012
 */

#ifndef SENSOR_NODE_H
#define SENSOR_NODE_H

#include "mbed.h"

const PinName CAN_RX = p30;
const PinName CAN_TX = p29;
const PinName LW_PIN = p11;
const PinName RW_PIN = p12;

const int ticksPerRevolution = 32;
const int tickerTimeout = 1;

class SensorNode {
public:
    SensorNode();
    ~SensorNode();
private:
    inline void Reset();
    void leftTick();
    void rightTick();
    void canSend();
    void canReceive();
    
    InterruptIn _leftWheel, _rightWheel;
    CAN _can;
    Serial _console;
    Ticker _statusTicker;
    volatile int _leftTicks, _rightTicks;
    volatile int _leftRevolutions, _rightRevolutions;
    volatile char _syncID;
};

#endif
