#ifndef DigitalPotentiometer_h
#define DigitalPotentiometer_h

#include "mbed.h"

#define MOSI	11
#define MISO	12
#define SCK		13

#define DigitalPotentiometer_MIN 0
#define DigitalPotentiometer_MAX 256

class DigitalPotentiometer
{
public:
    DigitalPotentiometer(PinName csPin);
	int initTCON();
	int readTCON();
	int readStatus();
	int increment();
	int decrement();
	int setTap(int value);
	
private:
    SPI _spi;
    DigitalOut _cs;
	void enable();
	void disable();
};

#endif
