#include "DigitalPotentiometer.h"

DigitalPotentiometer::DigitalPotentiometer(PinName csPin) : _spi(p5, p6, p7), _cs(csPin)
{
	_cs = 0;

	//Increase the frequency when external pull ups are used
    _spi.format(8,3);
    _spi.frequency(1000000);
}

int DigitalPotentiometer::increment() {
	_cs = 1;
	
	//  send in the address and value via SPI:
	char ret1 = _spi.write(0x04);

	_cs = 0;
	return ret1;
}

int DigitalPotentiometer::decrement() {
	_cs = 1;
	
	//  send in the address and value via SPI:
	char ret1 = _spi.write(0x08);
	
	_cs = 0;
	return ret1;
}

int DigitalPotentiometer::readTCON() {
	_cs = 1;
	
	//  send in the address and value via SPI:
	char ret1 = _spi.write(0x4C);
	char ret2 = _spi.write(0x00);
	
	_cs = 0;
	return ret1;
}

int DigitalPotentiometer::initTCON() {
	_cs = 1;
	
	//  send in the address and value via SPI:
	char ret1 = _spi.write(0x41);
	char ret2 = _spi.write(0x0F);
	
	_cs = 0;
	return ret1;
}

int DigitalPotentiometer::readStatus() {
	_cs = 1;
	
	//  send in the address and value via SPI:
	char ret1 = _spi.write(0x5C);
	char ret2 = _spi.write(0x00);
	
	_cs = 0;
	return ret1;
}

int DigitalPotentiometer::setTap(int value) {
	_cs = 1;

	//  send in the address and value via SPI:
	char h = 0x03 & (value >> 8);
	char l = 0x00FF & value;
	
	//Serial.print("HIGH: ");
	//Serial.println(h, BIN);
	//Serial.print("LOW: ");
	//Serial.println(l, BIN);
	
	char ret1 = _spi.write(h);
	char ret2 = _spi.write(l);

	_cs = 0;	
	return (ret1 << 8) | ret2;
}