/*
 * File: ControlNode/ControlNode.h
 * Author: William Jessup Salisbury
 * Company: Tufts Hybrid Racing Team
 * Copyright: CC BY-NC-SA 3.0
 * Date: 1/12/2012
 */

#ifndef CONTROL_NODE_H
#define CONTROL_NODE_H

#include "mbed.h"

const PinName CAN_RX = p30;
const PinName CAN_TX = p29;

const int tickerTimeout_us = 1000000;

class ControlNode {
public:
    ControlNode();
    ~ControlNode();
    void Init();
private:
    void canReset();
    void canSync();
    void canSend();
    void canReceive();

    CAN _can;
    Serial _console;
    Ticker _syncTimer;
    char _syncID;
};

#endif
