/*
 * File: ControlNode/ControlNode.cpp
 * Author: William Jessup Salisbury
 * Company: Tufts Hybrid Racing Team
 * Copyright: CC BY-NC-SA 3.0
 * Date: 1/12/2012
 */

#include "mbed.h"
#include "CANProtocol.h"
#include "ControlNode.h"

ControlNode::ControlNode() : _can(CAN_RX, CAN_TX), _console(USBTX, USBRX), _syncID(0) {
    //Nothing to see here
}

void ControlNode::Init() {
    /* CAN initialization */
    _can.frequency(CAN_FREQUENCY);
    _can.attach(this, &ControlNode::canReceive);

    /* Ticker initialization */
    _syncTimer.attach_us(this, &ControlNode::canSync, tickerTimeout_us);

    /* Print startup message */
    _console.printf("%s\r\n", "ControlNode instantiated.");
}

ControlNode::~ControlNode() {
    _syncTimer.detach();
}

void ControlNode::canReset() {
    CANMessage msg;
    msg.id = CAN_RESET;
    msg.len = 0;
    if (_can.write(msg)) {
        _console.printf("%s\r\n", "Reset message sent.");
    } else {
        _console.printf("%s\r\n", "Reset message send failure.");
    }
}

void ControlNode::canSync() {
    CANMessage msg;
    msg.id = CAN_SYNC;
    msg.len = 1;
    msg.data[0] = (++_syncID % 0xFF);
    if (_can.write(msg)) {
        _console.printf("%s\r\n", "Sync message sent.");
    } else {
        _console.printf("%s\r\n", "Sync message send failure.");
    }
}

void ControlNode::canSend() {
    CANMessage msg;

    if (_can.write(msg)) {
        _console.printf("%s\r\n", "Message sent.");
    } else {
        _console.printf("%s\r\n", "Message send failure.");
    }
}

void ControlNode::canReceive() {
    CANMessage msg;

    if (_can.read(msg)) {

        _console.printf("%s\r\n", "Message received.");

        if (msg.data[0] != _syncID) {
            _console.printf("%s\r\n", "'_syncID' mismatch.");
            return;
        }

        switch (msg.id) {
            case CAN_BRAKE:
                break;

            case CAN_ACCEL:
                break;

            case CAN_FLWS:
                break;

            case CAN_FRWS:
                break;

            case CAN_RLWS:
                break;

            case CAN_RRWS:
                break;

            case CAN_STATUS:
                _console.printf("%s\r\n", "CAN_STATUS Message received.");
                break;

            default:
                _console.printf("%s\r\n", "Message decode failure.");
                break;
        }
    } else {
        _console.printf("%s\r\n", "Message recieve failure.");
    }
}
