/*
 * File: CANProtocol/CANProtocol.h
 * Author: William Jessup Salisbury
 * Company: Tufts Hybrid Racing Team
 * Copyright: CC BY-NC-SA 3.0
 * Date: 1/12/2012
 */

#ifndef CANPROTOCOL_H
#define CANPROTOCOL_H

const int CAN_FREQUENCY = 500000; /* CANbus Speed ( 1000000 == 1Mbit/s ) */

const int CAN_RESET  = 0x100; /* Command Message: Reset */
const int CAN_SYNC   = 0x101; /* Command Message: Sync */
const int CAN_BRAKE  = 0x200; /* Critical Response: Brake Pedal */
const int CAN_ACCEL  = 0x201; /* Critical Response: Accelerator Pedal */
const int CAN_FLWS   = 0x300; /* Normal Response: Front Left Wheel Speed */
const int CAN_FRWS   = 0x301; /* Normal Response: Front Right Wheel Speed */
const int CAN_RLWS   = 0x302; /* Normal Response: Rear Left Wheel Speed */
const int CAN_RRWS   = 0x303; /* Normal Response: Rear Right Wheel Speed */
const int CAN_STATUS = 0x400; /* Relaxed Response: Status */

/* BMS CAN */
const int ID0 = 0x620;
const int ID1 = 0x621;
const int ID2 = 0x622;
const int ID3 = 0x623;
const int ID4 = 0x624;
const int ID5 = 0x625;
const int ID6 = 0x626;
const int ID7 = 0x627;
const int ID8 = 0x628;

#endif
