#include "mbed.h"
#include "EdpKit.h"

#define     TCPADD     "jjfaedp.hedevice.com"
#define     TCPPORT    876
#define 	DEVICE_ID	"10443217"
#define		API_KEY		"s9H5cODRLi8xjfTp2Nw9mZaKFeU="

// Network interface
NetworkInterface *net;
TCPSocket socket;
Thread thread_recv, thread_ping;
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);


void socket_recv()
{
    nsapi_size_or_error_t result;
	char *cmdid;
    char *req;
    uint16 cmdid_len;
    uint32 req_len;
    uint8 type;
    RecvBuffer *recv_buf;
    
    
    printf("start recv thread.\n");
    
    while (true) {
        recv_buf = NewBuffer();
        result = socket.recv(recv_buf->_data, 256);
	    if (result < 0) {
	        printf("Error! socket.recv() returned: %d\n", result);
			continue;
	    }
	    
	    recv_buf->_write_pos = result;
	    ReadByte(recv_buf, &type);
	    
	    if(type == 0xA0)
	    {
		    result = UnpackCmdReq(recv_buf, &cmdid, &cmdid_len, &req, &req_len);
		    
		    if(result == 0)
		    {
		    	printf("[%.*s]\n", req_len, req);
		    	if(strstr(req, "switch1"))
		    	{
		    		myled1 = req[req_len-1] - 0x30;
		    	}
		    	else if(strstr(req, "switch2"))
		    	{
		    		myled2 = req[req_len-1] - 0x30;
		    	}
		    	
		    }
	    }
    }
}

void socket_ping()
{
	EdpPacket* send_pack;
	
	while(1)
	{
		printf("ping onenet.\n");
		send_pack = PacketPing();
		socket.send(send_pack->_data,send_pack->_write_pos);   //send packge to OneNet Cloud
		
		wait(60);
	}
}


// Socket demo
int main() {
    int remaining;
    char *buffer = new char[256];
    EdpPacket* send_pack;
    nsapi_size_or_error_t result;

    // Bring up the ethernet interface
    printf("Mbed OS Socket example\n");

#ifdef MBED_MAJOR_VERSION
    printf("Mbed OS version: %d.%d.%d\n\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
#endif

    net = NetworkInterface::get_default_instance();

    if (!net) {
        printf("Error! No network inteface found.\n");
        return 0;
    }

    result = net->connect();
    if (result != 0) {
        printf("Error! net->connect() returned: %d\n", result);
        return result;
    }

    // Open a socket on the network interface, and create a TCP connection to ifconfig.io

    result = socket.open(net);
    if (result != 0) {
        printf("Error! socket.open() returned: %d\n", result);
    }
    
    result = socket.connect(TCPADD, TCPPORT);
    if (result != 0) {
        printf("Error! socket.connect() returned: %d\n", result);
        goto DISCONNECT;
    }

	printf("now linking to OneNet...\r\n");
    send_pack = PacketConnect1(DEVICE_ID, API_KEY);
    result = socket.send(send_pack->_data, send_pack->_write_pos);
	if (result < 0) {
        printf("Error! socket.send() returned: %d\n", result);
        goto DISCONNECT;
    }
	
    // Receieve an HTTP response and print out the response line
    remaining = 256;
    result = socket.recv(buffer, remaining);
    if (result < 0) {
        printf("Error! socket.recv() returned: %d\n", result);
        goto DISCONNECT;
    }
    
    if(buffer[3] != 0) {
    	printf("Error!link to onenet failed!\n");
    	goto DISCONNECT;
    }
    
    thread_recv.start(socket_recv);
    thread_ping.start(socket_ping);
    
    int number = 0;
    
    while(1) {
    	cJSON *json_data = cJSON_CreateObject();  //create a new json data
    	
    	scanf("%d", &number);
    	
    	cJSON_AddNumberToObject(json_data, "number", number); //pack data into json package
	    send_pack = PacketSavedataJson(DEVICE_ID, json_data, 3);  //pack send data into EDP package
	    cJSON_Delete(json_data);   //delete json_data, unless may cause memory leak  
	    
	    printf("send data number = %d\r\n", number);
	    
	    /*
	    for(i=0;i<send_pack->_write_pos;i++)
	    	printf("0X%02X ", send_pack->_data[i]);
	    printf("\n");
	    */
	    
	    result = socket.send(send_pack->_data,send_pack->_write_pos);   //send packge to OneNet Cloud
	    if (result < 0) {
	        printf("Error! socket.send() returned: %d\n", result);
	        goto DISCONNECT;
	    }
	    
	    wait(3);
    }
    
    delete[] buffer;
    
DISCONNECT:
    // Close the socket to return its memory and bring down the network interface
    socket.close();

    // Bring down the ethernet interface
    net->disconnect();
    printf("Done\n");
}
