/* ePy-Lite IO pins definitions
 * Copyright (c) 2021 Richlink Technology
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _EPY_LITE_IO_H_
#define _EPY_LITE_IO_H_

#include "mbed.h"

/* IO definitions for ePy-Lite */

#define BLE_DEFAULT_BAUD_RATE   115200
#define BLE_UART_TX             PA_9
#define BLE_UART_RX             PA_8
#define BLE_TIMEOUT             1000    // in milli-seconds

#define KEY_A                   PB_15
#define KEY_B                   PB_14   // Reserved.

#define LED_R                   PB_1
#define LED_Y                   PB_2
#define LED_G                   PB_3
#define LED_B                   LED_G
#define RGB_DAT                 PF_6    //  SPI0_MOSI for RGB LED

#define SPIFLASH_CS             PC_3
#define SPIFLASH_CLK            PC_2
#define SPIFLASH_SIO0           PC_0
#define SPIFLASH_SIO1           PC_1
#define SPIFLASH_SIO2           PC_5
#define SPIFLASH_SIO3           PC_4
#define SPIFLASH_MOSI           SPIFLASH_SIO0
#define SPIFLASH_MISO           SPIFLASH_SIO1
#define SPIFLASH_WP             SPIFLASH_SIO2   // low active
#define SPIFLASH_HOLD           SPIFLASH_SIO3   // low active
#define SPIFLASH_RESET          SPIFLASH_SIO3   // low active         

#define SPI0_SS                 PA_3
#define SPI0_CLK                PA_2
#define SPI0_MISO               PA_1
#define SPI0_MOSI               PA_0

#define I2C0_SCL                PB_5                
#define I2C0_SDA                PB_4
#define I2C1_SCL                PF_0
#define I2C1_SDA                PF_1
#define I2C2_SCL                PA_11
#define I2C2_SDA                PA_10

#define PWM0_                   PC_7
#define PWM1_                   PC_6
#define PWM2_                   PA_7
#define PWM3_                   PA_6

#define UART3_RX                PD_0
#define UART3_TX                PD_1
#define UART0_RX                PD_2
#define UART0_TX                PD_3
#define UART0_ALT_RX            PB_12
#define UART0_ALT_TX            PB_13

#define AIN0                    PB_6
#define AIN1                    PB_7
#define AIN2                    PB_8
#define AIN3                    PB_9
#define AIN4                    PB_10
#define AIN5                    PB_11

#define P0                      PD_0    // UART3_RX
#define P1                      PD_1    // UART3_TX
#define P2                      PD_2    // UART0_RX
#define P3                      PD_3    // UART0_TX
#define P4                      PF_1    // I2C1_SDA
#define P5                      PF_0    // I2C1_SCL
#define P6                      PA_0    // SPI0_MOSI
#define P7                      PA_1    // SPI0_MISO
#define P8                      PA_2    // SPI0_CLK
#define P9                      PA_3    // SPI0_SS
#define P10                     PA_6    // PWM3
#define P11                     PA_7    // PWM2
#define P12                     PC_6    // PWM1
#define P13                     PC_7    // PWM0
#define P14                     PA_10   // I2C2_SDA
#define P15                     PA_11   // I2C2_SCL
#define P16                     PB_4    // I2C0_SDA
#define P17                     PB_5    // I2C0_SCL
#define P18                     PB_6    // AIN0, EADC0_CH6
#define P19                     PB_7    // AIN1, EADC0_CH7
#define P20                     PB_8    // AIN2, EADC0_CH8
#define P21                     PB_9    // AIN3, EADC0_CH9
#define P22                     PB_10   // AIN4, EADC0_CH10
#define P23                     PB_11   // AIN5, EADC0_CH11
#define P24                     PB_15   // KEY_A

#if 1
class EPY_BLE /* : NonCopyable<EPY_BLE> */ {
    private:

    // UART settings
    mbed::BufferedSerial _serial;
    PinName _serial_rts;
    PinName _serial_cts;
    rtos::Mutex _smutex; // protect serial port access

    public:
        EPY_BLE(PinName tx, PinName rx, bool debug = false, PinName rts = NC, PinName cts = NC);
        ~EPY_BLE();

        void set_baud(int baud);
        bool start_uart_hw_flow_ctrl();
        bool stop_uart_hw_flow_ctrl();

        void set_timeout(uint32_t timeout = BLE_TIMEOUT);

        bool at_available(void);
        bool echo_off(void);
        void reset(void);
        void startup();

        const char *mac_addr(void);
        int scan();
        int8_t rssi();
        bool connect();
        bool disconnect();

        bool readable();
        bool writeable();
        ssize_t read(const void *buffer, std::size_t length);
        ssize_t write(const void *buffer, std::size_t length);
        ssize_t send(const void *buffer, std::size_t length);
        ssize_t recv(const void *buffer, std::size_t length);

};
#endif

#endif // _EPY_LITE_IO_H_
