/* ePy-Lite IO pins definitions
 * Copyright (c) 2021 Richlink Technology
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "epy_lite_io.h"

// Keys and LEDs on Board

// SPI Flash on Board

// BLE Class

EPY_BLE::EPY_BLE(PinName tx, PinName rx, bool debug, PinName rts, PinName cts) :
    _serial(tx, rx, BLE_DEFAULT_BAUD_RATE),
    _serial_cts(cts),
    _serial_rts(rts)
{

}

void EPY_BLE::set_baud(int baudrate)
{
    _serial.set_baud(baudrate);
}

bool EPY_BLE::start_uart_hw_flow_ctrl()
{
    return true;    
}