#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "MMA7660.h"
#define XI_FEED_ID 1000476735 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "ROxvAOZ6RznZjFPGufMNNn1LiMbYseCgEwF0qn1WAmcZPPY2" // set Xively API key (double-quoted string)

#include "app_board_io.h"

#include "xively.h"
#include "xi_err.h"

#define PST_OFFSET  7*60*60

Ticker timer;
C12832_LCD lcd; //Graphics LCD
EthernetInterface eth; //Networking functions
NTPClient ntp; //NTP client
LM75B tmp(p28,p27);
float lowTemp = 74;
float highTemp = 86;
float temp;
int heaterOn = 0;
AnalogIn pot1(p20);
AnalogIn pot2(p19);
#define LOOP_DELAY_MS 100
//update time every 10 minutes
#define UPDATE_TIME 60*1
#define UPDATE_XIVELY 60*1
MMA7660 axl(p28, p27);// accelerometer
int updateTimeFromServer = 1;

//Xively globals
int update_xively = 1;
xi_feed_t feed;
xi_datapoint_t* current_temperature;
xi_datapoint_t* current_x;
xi_datapoint_t* current_y;
xi_datapoint_t* current_z;
xi_datapoint_t* current_heaterstatus;
xi_datastream_t* heaterstatus_datastream;
xi_context_t* xi_context;


void setUpXively() {
    memset( &feed, NULL, sizeof( xi_feed_t ) );
    
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 5;
    
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* temperature_datastream = &feed.datastreams[0];
    strcpy( temperature_datastream->datastream_id, "temperature" );
    current_temperature = &temperature_datastream->datapoints[0];

    feed.datastreams[1].datapoint_count = 1;
    xi_datastream_t* axl_x_datastream = &feed.datastreams[1];
    strcpy( axl_x_datastream->datastream_id, "axl_x" );
    current_x = &axl_x_datastream->datapoints[0];
    
    feed.datastreams[2].datapoint_count = 1;
    xi_datastream_t* axl_y_datastream = &feed.datastreams[2];
    strcpy( axl_y_datastream->datastream_id, "axl_y" );
    current_y = &axl_y_datastream->datapoints[0];
    
    feed.datastreams[3].datapoint_count = 1;
    xi_datastream_t* axl_z_datastream = &feed.datastreams[3];
    strcpy( axl_z_datastream->datastream_id, "axl_z" );
    current_z = &axl_z_datastream->datapoints[0];
    
    feed.datastreams[4].datapoint_count = 1;
    heaterstatus_datastream = &feed.datastreams[4];
    strcpy( heaterstatus_datastream->datastream_id, "heater_status" );
    current_heaterstatus = &heaterstatus_datastream->datapoints[0];
    
    // create the cosm library context
    xi_context = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

}

void connectToTheInternet()
{
    eth.init(); //Init and use DHCP
    wait(2);
    lcd.cls();
    lcd.printf("Getting IP Address\r\n");
    printf("\n\rGetting IP Address\r\n");
    if(eth.connect(60000)!=0) {
        lcd.printf("DHCP error - No IP");
        wait(10);
    } else {
        lcd.printf("IP is %s\n", eth.getIPAddress());
        printf("IP is %s\n", eth.getIPAddress());
        wait(2);
    }
    lcd.cls();
}

void updateTimeRoutine()
{
    if (ntp.setTime("0.pool.ntp.org") == 0) {
        printf("Time updated!");
    } else {
        lcd.locate(0,0);
        printf("Time update failed \n\r");
        lcd.printf("Time update failed");
    }
    updateTimeFromServer = 0;
}

void updateTime()
{
    updateTimeFromServer = 1;
}

void updateXively() {
    update_xively = 1;    
}

void updateXivelyRoutine() {
    xi_set_value_f32( current_temperature, tmp.read() );
    xi_set_value_f32( current_x, axl.x() );
    xi_set_value_f32( current_y, axl.y() );
    xi_set_value_f32( current_z, axl.z() );
    update_xively = 0;  
    printf( "update...\n" );
    xi_feed_update( xi_context, &feed );
    
    //xi_response_t myInData;
    //myInData = xi_feed_get(xi_context, &feed);
    xi_datastream_get(xi_context, feed.feed_id, heaterstatus_datastream->datastream_id, heaterstatus_datastream->datapoints);
    printf( "\n\rHEATER STATUS: %d...\n",heaterstatus_datastream->datapoints[0]);
    current_heaterstatus = &heaterstatus_datastream->datapoints[0];
    int heatervalue = current_heaterstatus->value.i32_value;
    printf("HeaterStatus: %d", heatervalue);
    printf( "done...\n" ); 
}

//POT values are 0:1, will allow high and low temperatures
//lets you set temp between 50 and 100 degrees
void updateTempsFromPots()
{
    float lowTempPot = pot2*50.0+50;
    float highTempPot = pot1*50.0+50;
    //round to the nearest whole number
    lowTempPot = floor(lowTempPot+.5);
    highTempPot = floor(highTempPot+.5);
    //high temp must be at least 1 degree above low temp
    if (highTempPot <= lowTempPot) {
        highTempPot = lowTempPot +1;
    }
    //Refresh the display if the temps have changed by more than a degree
    if ((lowTemp != lowTempPot) || (highTemp != highTempPot)) {
        lowTemp = lowTempPot;
        highTemp = highTempPot;
        lcd.locate(0,0);
        lcd.printf("\n\r%.1f LOW: %.0f HIGH: %.0f", temp, lowTemp, highTemp);
        printf("LOW: %.2f HIGH: %.2f\n\r", lowTemp, highTemp);
    }
}

int main()
{
    connectToTheInternet();
    setUpXively();
    //Variable to hold the current minute so we only update the display when the minute changes
    char currentMinute[2];
    currentMinute[1] = 'a';
    char minute[2];

    float currentTemp = -200;
    lcd.printf("Updating time...\r\n");
    printf("Updating time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0) {
        printf("Set time successfully\r\n");
        lcd.cls();
        timer.attach(&updateTime, UPDATE_TIME);
        timer.attach(&updateXively, UPDATE_XIVELY);
        lcd.printf("\n\r\n\rHEATER OFF");

        while(1) {
            if(updateTimeFromServer) {
                updateTimeRoutine();
            }
            if(update_xively){
                updateXivelyRoutine();
            }
            //Sets temp from POTs
            updateTempsFromPots();
            //Fetch the time
            time_t ctTime;
            ctTime = time(NULL)- PST_OFFSET;
            char timeBuffer[32];

            //See if the minute has changed; set an update display flag if it has
            strftime(minute, 8, "%M", localtime(&ctTime));
            if ( (minute[1] != currentMinute[1]) ) {
                //Formats the time for display
                strftime(timeBuffer, 32, "%a %b %d %I:%M%p\n\r", localtime(&ctTime));
                printf("%s\r", timeBuffer);
                lcd.locate(0,0);
                lcd.printf("%s\r", timeBuffer);
                currentMinute[1] = minute[1];
            }

            //Update the temperature display if the temperature, set temp has changed
            temp = tmp.read()*9.0/5.0 + 32.0;

            //checks if the temperature (rounded to the nearest whole number) has changed
            if (floor(temp+.5) != floor(currentTemp+.5)) {
                printf("Temp change: %.1f F\n\r", temp);
                currentTemp = temp;
                lcd.locate(0,0);
                //updates the temperature line of the display
                lcd.printf("\n\r%.1f LOW: %.0f HIGH: %.0f", temp, lowTemp, highTemp);
            }

            lcd.locate(0,0);
            
            //Heater logic: turns off if it has gone over the high temp and is on,
            //or if under the low temp and is off
            if (heaterOn && (temp > highTemp) ) {
                printf("Heater turned OFF\n\r");
                heaterOn = 0;
                lcd.locate(0,0);
                lcd.printf("\n\r\n\rHEATER OFF");
            } else if (!heaterOn && (temp < lowTemp) ) {
                printf("Heater turned ON\n\r");
                heaterOn = 1;
                lcd.locate(0,0);
                lcd.printf("\n\r\n\rHEATER ON");
            }
            wait(LOOP_DELAY_MS*.001);
        }
    } else {
        lcd.printf("NTP Error\r\n");
    }
    eth.disconnect();
}