/**
@file main.cpp Thread_use7
 
@brief Code which uses two potentiometers to control the brightness of on board LED's, at the same time, using threads.

@Authour Louis Wray

@Date 8th December 2015

Think of threads as "paths" except your code can walk down more than one path a time a time
*/
#include "mbed.h"
#include "rtos.h" // real time operating system (rtos) library


/**
@namespace Potentiometer
@brief represents potentiometer in value on pin 20
*/
AnalogIn Potentiometer(p20);

/**
@namespace Potentiometer1
@brief represents potentiometer in value on pin 19
*/
AnalogIn Potentiometer1(p19);

/**
@namespace led
@brief represents on board LED initialised to have brightness controlled with PWM
*/
PwmOut led(LED1);

/**
@namespace led1
@brief represents on board LED initialised to have brightness controlled with PWM
*/
PwmOut led1(LED4);

/**
function used as main for created thread.
controls on board LED with potentiometer
*/
void LED2_CONTROL(void const *args)    /// This is the thread function, essentially another int main()            
{
    while(1) {
        led = Potentiometer.read();
        Thread::wait(1); /// Thread::wait(x) must be inclued and x must be a real integer greater than 0, this is because it is a "status code"
        /// and the status code is indicating the execution status of the function, so setting this wait also actually sets the
        /// execution status, meaning it shows the thread is being executed.
        /// the integer x is in MILLI_SECONDS
    }

}


int main()
{

    Thread thread(LED2_CONTROL); /// set the Thread, give the Thread a name (thread) and assign 
                                 /// a function to designate as the seperate thread

    while (1) {

        led1 = Potentiometer1.read();
        Thread::wait(1); /// indicates status of this thread also


    }
}

