#include "rgbLed.h"

#define COMMON_ANODE
 
RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}
 
void RGBLed::write(float red,float green, float blue)
{
    #ifdef COMMON_ANODE
    red = 1 - red;
    green = 1 - green;
    blue = 1 - blue;
    #endif
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}

void RGBLed::write(LEDColor c)
{
    #ifdef COMMON_ANODE
        _redpin = 1 - c.red;
        _greenpin = 1 - c.green;
        _bluepin = 1 - c.blue;
    #else
        _redpin = c.red;
        _greenpin = c.green;
        _bluepin = c.blue;
    #endif
}
