#include "mbed.h"
#include "m3pi.h"

//Ticker toggler1;  // periodic interrupt routines
InterruptIn risingEdge(p16);

m3pi m3pi;
Serial Wixel(p28, p27); // tx, rx
AnalogIn analog (p20);
DigitalOut myled(LED1);

int behaviour;
float inc;
bool incCurve;
bool sign = true;
volatile int ledValue;

void changeCurve()
{
    if (sign)
    {
        inc = 0.35;
    }
    else
    {
        inc = 0.45;
    }
    sign = !sign;
}

//Generate series of circles with different radius
void seriesOfCircle()
{
    if(incCurve)
    {
        inc += 0.001;
    }
    else
    {
        inc -= 0.001;        
    }
    
    if(inc >= 0.6){incCurve = false;}
    if(inc <= 0.45){incCurve = true;}
}

void toggleLED()
{

    if (ledValue == 0)
    {
        ledValue = 1;
    }
    else
    {
        ledValue = 0;
    }

   myled = ledValue;
   
}

unsigned int random_generator (void)
{
    unsigned int x = 0;
    unsigned int iRandom = 0;
 
    for (x = 0; x <= 32; x += 2)
    {
        iRandom += ((analog.read_u16() % 3) << x);
        wait_us (10);
    }
    
    return iRandom;
}

//main program
int main() 
{
     
    Wixel.baud(115200);
    //srand (random_generator()); // Using ADC value to generate random seed
    risingEdge.rise(&toggleLED);
    ledValue = 0;
    //toggler1.attach(&changeCurve,0.9);  // toggles curve every 900 ms
    //inc = 0.45;
    //incCurve = true;
    while(1)  
    {
        //behaviour = rand() % 5 + 1;        
        switch (behaviour)
        {
            case 1:
                // This is for testing rose curve
                //m3pi.left_motor(inc);
                //wait(0.1);
                //m3pi.right_motor(0.7);
                //wait(0.1);
                break;
            case 2:
            
                break;
        }
    }
       
}


