#ifndef LAMBORSTEER_H
#define LAMBORSTEER_H

#include "mbed.h"

#define MAX_SERVOS 2
#define MIN_POT_VALUE 10   
#define MAX_POT_VALUE 1000  // 800
#define MIN_ANGLE 10
#define MAX_ANGLE 400       // 170

typedef unsigned char uint8_t;

typedef struct {
    int wanted_angle;
    int current_angle;
    uint8_t speed;
} servo_status;

class LamborSteer
{
public:
    LamborSteer(PinName _cw_pin, PinName _ccw_pin, PinName _enablerPin, PinName _sensor_pin, int _offset);
    //void attach();
    void timer_int_routine();  
    void detach();
    void write(int degrees);
    void update();
    servo_status read();

    bool active;
    int index;
private:               
    int offset;
    uint8_t speed;
    int wanted_position;
    int tolerance;
    int constrained_value;
    
    void write_pot_value(int degrees);
    void run_cw();
    void run_ccw();
    void stop();
    int get_position();
    long map(long x, long in_min, long in_max, long out_min, long out_max);
    DigitalOut cw_pin;
    DigitalOut ccw_pin;
    PwmOut enabler_pin;
    AnalogIn sensor_pin;
};

static int s_index;                 // number of registered servo's
static LamborSteer* _m_servos[2];   // array containing registered servo's
#endif
