
/***************************< File comment >***************************/  
/* project:   Lamborghini's steering                                  */ 
/* project description : Mobile Robot                                 */ 
/*--------------------------------------------------------------------*/ 
/* version : 0.1                                                      */ 
/* board : NUCLEO-F746ZG                                              */ 
/* detail : DC motor position control with potentiometer              */
/*--------------------------------------------------------------------*/ 
/* create : 02/11/2018                                                */ 
/* programmer : Worasuchad Haomachai                                  */ 
/**********************************************************************/ 
 
/*--------------------------------------------------------------------*/ 
/*                           Include file                             */ 
/*--------------------------------------------------------------------*/
#include "mbed.h" 
#include "LamborSteer.h"

Serial pc(USBTX, USBRX);                            //Serial Port
LamborSteer lamborSteer(D4, D5, D6, A4, 0);         //InA, InB, PWM, Potentiometer, Offset
Ticker intRoutine;
InterruptIn mybutton1(D13);
InterruptIn mybutton2(D12);
/*--------------------------------------------------------------------*/ 
/*                         Global variable                            */ 
/*--------------------------------------------------------------------*/
int angle;
char command; 

/*--------------------------------------------------------------------*/ 
/*                           prototype fun                            */ 
/*--------------------------------------------------------------------*/
void pressed();

/*--------------------------------------------------------------------*/ 
/*                              main                                  */ 
/*--------------------------------------------------------------------*/
int main()
{
  pc.baud(115200);
  intRoutine.attach(&lamborSteer, &LamborSteer::timer_int_routine, 0.001);      // the address of the object, member function, and interval(1ms)
  mybutton1.fall(&pressed);
  mybutton2.fall(&pressed);
  lamborSteer.write(200);
  
  while(1)
  {
      if(pc.readable()) 
      {
        command = pc.getc();        
        pc.printf("%d\n\r", angle);
        if(command == 'a')
        {
            angle = angle + 10;
        }
        else if(command == 'd')
        {
            angle = angle - 10;
        }
        
        if(angle > 0 && angle < 400)
        {
          lamborSteer.write(angle);
        }
      }
  }
}

/*--------------------------------------------------------------------*/ 
/*                              pressed                               */ 
/*--------------------------------------------------------------------*/ 
void pressed()
{
    angle = 200;
    lamborSteer.write(angle);
}
/*--------------------------------------------------------------------*/