#include "mbed.h"

int mode = 1;                               //0＝電気信号発生器 1=駆動信号発生器
int revision = 1;

//Serial Port Setting
Serial pc(p13, p14); // シリアルポートのインスタンス

//PWM Port Setting
PwmOut signal_1(p23);
PwmOut signal_2(p22);
PwmOut signal_3(p21);

//Ticker
Ticker timer;

//Digital Out
DigitalOut ledch1(LED1);

//cos Wave
float coswave[256];

//status flug
int   status1 =0;                                   //suatus1 : 0=波形出力停止中, 1=波形出力中

//User set Wave Paramater 初期値
int   sample_dt             = 100;                  //microsec 10kHz
float hb_carr_freq          = 8.7;                  //Hz       
float hb_mod_freq           = 1;                    //Hz
float hb_carr_level         = 0.06;                //min=0 max=0.5 0.5以上ではMOD 50%以上で振幅が飽和する
float hb_mod_ratio          = 60;                   //0-100 %
float resp_freq             = 0.3;                  //Hz
float resp_level            = 0.23;                 //min=0 max=1
float snore_freq            = 150;                  //Hz
float snore_level           = 0.045;                 //min=0 max=1 
int snore_oncycle           = 10000;                //On Time = snore_oncycle * sample_dt, snore_oncycle < snore_allcycle;
int snore_allcycle          = 33333;                //OFF Time = (allcycle - oncycle) * sample_dt
int snore_onoff             = 1;                    //0: ALL Time ON, 1:On Time only

//Set wave paramater
//HB_carr
float hb_carr_period        = 1000000*1/hb_carr_freq;  //microSec  
float hb_carr_n             = 0;
float hb_carr_n_sample      = 0;                    //The maximum number of sampling points in the signal
float hb_carr_tend          = 0;                    //The remainder of sampling points in the signal
float hb_carr_tstart        = 0;                    //start offset of sampling time
float hb_carr_t_samplepoint = 0;        
float hb_carr_table_dt      = hb_carr_period/256;
float hb_carr_n_samplepoint = 0;
float hb_carr_v_samplepoint = 0;

//HB_mod
float hb_mod_period        = 1000000*1/hb_mod_freq;
float hb_mod_n             = 0;
float hb_mod_n_sample      = 0;                    //The maximum number of sampling points in the signal
float hb_mod_tend          = 0;                    //The remainder of sampling points in the signal
float hb_mod_tstart        = 0;                    //start offset of sampling time
float hb_mod_t_samplepoint = 0;        
float hb_mod_table_dt      = hb_mod_period/256;
float hb_mod_n_samplepoint = 0;
float hb_mod_v_samplepoint = 0;

float hb_mod_ra             = hb_mod_ratio * 0.01;
float hb_signal             = 0;
float mod_signal            = 0;

//RESP
float resp_period           = 1000000*1/resp_freq;  //microSec      
float resp_n                = 0;
float resp_n_sample         = 0;                    //The maximum number of sampling points in the signal
float resp_tend             = 0;                    //The remainder of sampling points in the signal
float resp_tstart           = 0;                    //start offset of sampling time
float resp_t_samplepoint    = 0;           
float resp_table_dt         = resp_period/256;                                            
float resp_n_samplepoint    = 0;
float resp_v_samplepoint    = 0;
float resp_signal           = 0;

//SNORE Paramater
float snore_period          = 1000000*1/snore_freq;  //microSec
float snore_n               = 0;                    
float snore_n_sample        = 0;                    //The maximum number of sampling points in the signal
float snore_tend            = 0;                    //The remainder of sampling points in the signal
float snore_tstart          = 0;                    //start offset of sampling time
float snore_t_samplepoint   = 0;        
float snore_table_dt        = snore_period/256;     //2016/12/12 255->256
float snore_n_samplepoint   = 0;
float snore_v_samplepoint   = 0;
int   snore_cycle           = 0;
float snore_signal          = 0;

int   pwidth_1 = 0;
int   pwidth_2 = 0;
int   pwidth_3 = 0;

// Debug use only   ----
int dbcount = 0;

// End of debug use ----

//Signal Culcurate
void signal_culc(){
       
//HB section
//HB_carr
        hb_carr_n_sample = (hb_carr_period - hb_carr_tstart) / sample_dt;
        hb_carr_tend = fmod((hb_carr_period - hb_carr_tstart) , sample_dt);  
        if(hb_carr_tend == 0){
            hb_carr_n_sample = hb_carr_n_sample-1;
            }   
        hb_carr_t_samplepoint = hb_carr_tstart + sample_dt * hb_carr_n; //time of sampling point
        hb_carr_n_samplepoint = hb_carr_t_samplepoint / hb_carr_table_dt;
        if(hb_carr_n_samplepoint >= 256){
            hb_carr_n_samplepoint = 0;
            }    
        hb_carr_v_samplepoint = coswave[(int)hb_carr_n_samplepoint];
        if(hb_carr_n > (int)hb_carr_n_sample) {
            hb_carr_n =0;
            hb_carr_tstart = sample_dt - hb_carr_tend;
            }          
        else {
            hb_carr_n++;           
            }
//HB_mod
//A(1+macosωmt)*cosωct     Acosωct = fcarr(t),ma = modulation ratio,
        hb_mod_n_sample = (hb_mod_period - hb_mod_tstart) / sample_dt;
        hb_mod_tend = fmod((hb_mod_period - hb_mod_tstart) , sample_dt); 
        if(hb_mod_tend == 0){
            hb_mod_n_sample = hb_mod_n_sample-1;
            }    
        hb_mod_t_samplepoint = hb_mod_tstart + sample_dt * hb_mod_n; //time of sampling point    
        hb_mod_n_samplepoint = hb_mod_t_samplepoint / hb_mod_table_dt;
        if(hb_mod_n_samplepoint >= 256){
            hb_mod_n_samplepoint = 0;
            }
        hb_mod_v_samplepoint = hb_mod_ra*(coswave[(int)hb_mod_n_samplepoint]);  
        if(hb_mod_n > (int)hb_mod_n_sample) {
            hb_mod_n =0;
            hb_mod_tstart = sample_dt - hb_mod_tend;
            }
        else {
            hb_mod_n++;           
            }
        
//HB_AM MOD 
        
        hb_signal = 0.5*(hb_carr_level*(1+hb_mod_v_samplepoint)*hb_carr_v_samplepoint)+0.5;//0-1 -> 0V-3.3V
 
//debug part      
/*
        if(dbcount>=100){
            pc.printf("%f, %f, %f\n",hb_signal,mod_signal,hb_mod_v_samplepoint);
            dbcount = 0;
            }
        dbcount++;
*/     
//end debug part
        
//RESP section
        resp_n_sample = (resp_period - resp_tstart) / sample_dt;
        resp_tend = fmod((resp_period - resp_tstart) , sample_dt);
        if(resp_tend == 0){
            resp_n_sample = resp_n_sample-1;
            }
        resp_t_samplepoint = resp_tstart + sample_dt * resp_n; //time of sampling point
        resp_n_samplepoint = resp_t_samplepoint / resp_table_dt;
        if(resp_n_samplepoint >= 256){
            resp_n_samplepoint = 0;
            }
        resp_v_samplepoint = resp_level*(coswave[(int)resp_n_samplepoint]);
        resp_signal = 0.5*resp_v_samplepoint+0.5;     //0-1 -> 0V-3.3V
        if(resp_n > (int)resp_n_sample) {
            resp_n =0;
            resp_tstart = sample_dt - resp_tend;
            }      
        else {
            resp_n++;         
            }
            
//SNORE section
        snore_n_sample = (snore_period - snore_tstart) / sample_dt;       //
        snore_tend = fmod((snore_period - snore_tstart) , sample_dt);
        if(snore_tend == 0){
            snore_n_sample = snore_n_sample-1;
            }
        else {
            }
        snore_t_samplepoint = snore_tstart + sample_dt * snore_n; //time of sampling point
        snore_n_samplepoint = snore_t_samplepoint / snore_table_dt;
        if(snore_n_samplepoint >= 256){
            snore_n_samplepoint = 0;
            }
        snore_v_samplepoint = snore_level*(coswave[(int)snore_n_samplepoint]);
        if(snore_n > (int)snore_n_sample) {
            snore_n =0;             //2016/12/12 1->0
            snore_tstart = sample_dt - snore_tend;
            }
        else {
            snore_n++;          
            } 
        if(snore_onoff==0){
            }
        else if(snore_onoff==1){
            if (snore_cycle <= snore_oncycle) {
                snore_cycle++;
                }
            else if (snore_cycle>snore_oncycle && snore_cycle <= snore_allcycle){
                snore_v_samplepoint = 0;
                snore_cycle++;
                }
            else {
                snore_cycle = 0;
                }
            }    
        snore_signal = 0.5*snore_v_samplepoint+0.5;   //0-1 -> 0V-3.3V
            
//PWM Output Pulse width
        pwidth_1 = hb_signal * sample_dt;
        pwidth_2 = resp_signal * sample_dt;
        pwidth_3 = snore_signal * sample_dt;
        
        signal_1.pulsewidth_us(pwidth_1);
        signal_2.pulsewidth_us(pwidth_2);
        signal_3.pulsewidth_us(pwidth_3); 
}

//チッカー割り込みハンドラ
void attime(){
    if(status1==1){
        ledch1=0;
        signal_culc();
        }
    else{
        ledch1=!ledch1;
        }
    }

//Serial 受信割り込みハンドラ
void isrRx() {
        
    /*  UART受信コマンド
    start:      波形出力スタート
    stop:       波形出力ストップ
    St:         割り込み周期[μsec]
    carrf:      脈波AM変調波搬送波周波数[Hz]
    modf:       脈波AM変調波変調周波数[Hz]
    carrl:      脈波振幅
    modr:       脈波変調波変調率[%]
    respf:      呼吸周波数[Hz]
    respl:      呼吸振幅
    snorf:      体動・イビキ周波数[Hz]
    snorl:      体動・イビキ振幅
    snon:       体動・イビキONサイクル      
    snall:      体動・イビキALLサイクル 
    sncn:       体動・イビキ断続制御       
    */
    
    char scan[10];
    float para;

    pc.scanf("%s",scan);                            // 文字列受信バッファより取り出し
//    pc.printf("read = %s\n",scan);
  
    if(strcmp(scan,"start")==0){
        pc.printf("go\n");
        status1=1;                                  //波形出力状態へ遷移
        }
    else if(strcmp(scan,"stop")==0){
        pc.printf("end\n");
        status1=0;                                  //波形出力停止へ遷移
        }
    else if(strcmp(scan,"dt")==0){    
        pc.scanf("%f",&para); 
        sample_dt       =   para;
        pc.printf("dt = %f\n",sample_dt);
        } 
    else if(strcmp(scan,"carrf")==0){    
        pc.scanf("%f",&para);
        hb_carr_freq          = para;
        hb_carr_period        = 1000000*1/hb_carr_freq;  //microSec
        hb_carr_n             = 0;
        hb_carr_n_sample      = 0;                  //The maximum number of sampling points in the signal
        hb_carr_tend          = 0;                  //The remainder of sampling points in the signal
        hb_carr_tstart        = 0;                  //start offset of sampling time
        hb_carr_t_samplepoint = 0;        
        hb_carr_table_dt      = hb_carr_period/256;
        hb_carr_n_samplepoint = 0;
        hb_carr_v_samplepoint = 0;
        pc.printf("carrf = %f\n",hb_carr_freq);
        hb_mod_period        = 1000000*1/hb_mod_freq;
        hb_mod_n             = 0;
        hb_mod_n_sample      = 0;                  //The maximum number of sampling points in the signal
        hb_mod_tend          = 0;                  //The remainder of sampling points in the signal
        hb_mod_tstart        = 0;                  //start offset of sampling time
        hb_mod_t_samplepoint = 0;        
        hb_mod_table_dt      = hb_mod_period/256;
        hb_mod_n_samplepoint = 0;
        hb_mod_v_samplepoint = 0;
        }
    else if(strcmp(scan,"modf")==0){    
        pc.scanf("%f",&para);  
        hb_mod_freq           = para;
        hb_mod_period        = 1000000*1/hb_mod_freq;
        hb_mod_n             = 0;
        hb_mod_n_sample      = 0;                  //The maximum number of sampling points in the signal
        hb_mod_tend          = 0;                  //The remainder of sampling points in the signal
        hb_mod_tstart        = 0;                  //start offset of sampling time
        hb_mod_t_samplepoint = 0;        
        hb_mod_table_dt      = hb_mod_period/256;
        hb_mod_n_samplepoint = 0;
        hb_mod_v_samplepoint = 0;
        pc.printf("modf = %f\n",hb_mod_freq);
        hb_carr_n             = 0;
        hb_carr_n_sample      = 0;                  //The maximum number of sampling points in the signal
        hb_carr_tend          = 0;                  //The remainder of sampling points in the signal
        hb_carr_tstart        = 0;                  //start offset of sampling time
        hb_carr_t_samplepoint = 0;        
        hb_carr_table_dt      = hb_carr_period/256;
        hb_carr_n_samplepoint = 0;
        hb_carr_v_samplepoint = 0;
        }
    else if(strcmp(scan,"carrl")==0){    
        pc.scanf("%f",&para);  
        hb_carr_level         = para;
        pc.printf("carrl = %f\n",hb_carr_level);
        }    
    else if(strcmp(scan,"modr")==0){    
        pc.scanf("%f",&para); 
        hb_mod_ratio          = para;
        hb_mod_ra             = hb_mod_ratio *0.01;
        pc.printf("modr = %f\n",hb_mod_ra);
        } 
    else if(strcmp(scan,"respf")==0){    
        pc.scanf("%f",&para); 
        resp_freq             = para; 
        resp_period           = 1000000*1/resp_freq;//microSec      
        resp_n                = 0;
        resp_n_sample         = 0;                  //The maximum number of sampling points in the signal
        resp_tend             = 0;                  //The remainder of sampling points in the signal
        resp_tstart           = 0;                  //start offset of sampling time
        resp_t_samplepoint    = 0;           
        resp_table_dt         = resp_period/256;                                            
        resp_n_samplepoint    = 0;
        resp_v_samplepoint    = 0;
        pc.printf("respf = %f\n",resp_freq);  
        } 
    else if(strcmp(scan,"respl")==0){    
        pc.scanf("%f",&para); 
        resp_level            = para;
        pc.printf("respl = %f\n",resp_level); 
        } 
    else if(strcmp(scan,"snorf")==0){    
        pc.scanf("%f",&para);   
        snore_freq            = para; 
        snore_period          = 1000000*1/snore_freq;  //microSec
        snore_n               = 0;                  //2016/12/12 1->0
        snore_n_sample        = 0;                  //The maximum number of sampling points in the signal
        snore_tend            = 0;                  //The remainder of sampling points in the signal
        snore_tstart          = 0;                  //start offset of sampling time
        snore_t_samplepoint   = 0;        
        snore_table_dt        = snore_period/256;
        snore_n_samplepoint   = 0;
        snore_v_samplepoint   = 0;  
        snore_cycle           = 0;
        pc.printf("snorf = %f\n",snore_freq);     
    } 
    else if(strcmp(scan,"snorl")==0){    
        pc.scanf("%f",&para); 
        snore_level           = para;
        pc.printf("snorl = %f\n",snore_level); 
    } 
    else if(strcmp(scan,"snon")==0){    
        pc.scanf("%f",&para); 
        snore_oncycle         = (int)para; 
        pc.printf("snon = %d\n",snore_oncycle);     
    } 
    else if(strcmp(scan,"snall")==0){    
        pc.scanf("%f",&para); 
        snore_allcycle        = (int)para; 
        pc.printf("snall = %d\n",snore_allcycle);   
    } 
    else if(strcmp(scan,"sncn")==0){    
        pc.scanf("%f",&para); 
        snore_onoff           = (int)para;
        pc.printf("sncn = %d\n",snore_onoff);  
    } 
    else if(strcmp(scan,"ack")==0){
        pc.printf("carrf = %f\n",hb_carr_freq);
        pc.printf("carrl = %f\n",hb_carr_level);
        pc.printf("modf = %f\n",hb_mod_freq);
        pc.printf("modr = %f\n",hb_mod_ra);
        pc.printf("respf = %f\n",resp_freq);  
        pc.printf("respl = %f\n",resp_level); 
        pc.printf("snorf = %f\n",snore_freq);     
        pc.printf("snorl = %f\n",snore_level); 
        pc.printf("snon = %d\n",snore_oncycle);     
        pc.printf("snall = %d\n",snore_allcycle);   
        pc.printf("sncn = %d\n",snore_onoff); 
    }
    else if(strcmp(scan,"mr")==0){
        pc.printf("mode = %d\n",mode);
        pc.printf("revision = %d\n",revision);
    }
    else {
        pc.printf("Command Error\n");
    }   
}

int main() {
    pc.printf("Start Up\n");
    
//Make cos wave
    int i;
    for(i=0;i<=255;i++){                         
        coswave[i]=cos(2.0*3.1415*i/256);           //2017/1/5  0.5*(cos(2.0*3.1415*i/256));                         
    }
    i = 0;

    signal_1.period_us(sample_dt);                  //Pulse_cycle = 100usec = 10kHz
    signal_2.period_us(sample_dt);
    signal_3.period_us(sample_dt);
    
    int j;
    j = sample_dt;
    timer.attach_us(&attime,j);                     //⇒UART割り込み”START”に移動     
    
    pc.attach(isrRx, Serial::RxIrq);                // 割込みハンドラ登録
    NVIC_SetPriority(UART1_IRQn,1);

    while(1) {                  
        }
}
