#include "mbed.h"

//PWM
PwmOut signal_1(p21);
PwmOut signal_2(p22);
PwmOut signal_3(p23);

//Ticker
Ticker timer;

//Timer
//Timer ta;

//Digital Out
DigitalOut test(p20);

//Cos Wave
float coswave[256];

//User set Wave Paramater
int sample_dt               = 100;      //microsec 10kHz
float hb_carr_freq          = 8.7;      //Hz       
float hb_mod_freq           = 1;        //Hz
float hb_carr_level         = 0.083;      //min=0 max=0.5 0.5以上ではMOD 50%以上で振幅が飽和する 
float hb_mod_ratio          = 100;       //0-100 %
float resp_freq             = 0.3;      //Hz
float resp_level            = 0.56;        //min=0 max=1 
float snore_freq            = 150;      //Hz
float snore_level           = 0.23;      //min=0 max=1 
int snore_oncycle           = 10000;     //On Time = snore_oncycle * sample_dt
int snore_allcycle          = 20000;     //ALL Time = snore_allcycle * sample_dt , snore_oncycle < snore_allcycle;

//Set wave paramater
//HB_carr
float hb_carr_period        = 1000000*1/hb_carr_freq;  //microSec  
float hb_carr_n             = 1;
float hb_carr_n_sample      = 0;        //The maximum number of sampling points in the signal
float hb_carr_tend          = 0;        //The remainder of sampling points in the signal
float hb_carr_tstart        = 0;        //start offset of sampling time
float hb_carr_t_samplepoint = 0;        //
float hb_carr_table_dt = hb_carr_period/255;
float hb_carr_n_samplepoint = 0;
float hb_carr_rem_samplepoint=0;
float hb_carr_v_samplepoint = 0;

//HB_mod
float hb_modp_period        = 1000000*1/(hb_carr_freq + hb_mod_freq);
float hb_modp_n             = 1;
float hb_modp_n_sample      = 0;        //The maximum number of sampling points in the signal
float hb_modp_tend          = 0;        //The remainder of sampling points in the signal
float hb_modp_tstart        = 0;        //start offset of sampling time
float hb_modp_t_samplepoint = 0;        //
float hb_modp_table_dt      = hb_modp_period/255;
float hb_modp_n_samplepoint = 0;
float hb_modp_rem_samplepoint= 0;
float hb_modp_v_samplepoint = 0;

float hb_modm_period        = 1000000*1/(hb_carr_freq - hb_mod_freq);
float hb_modm_n             = 1;
float hb_modm_n_sample      = 0;        //The maximum number of sampling points in the signal
float hb_modm_tend          = 0;        //The remainder of sampling points in the signal
float hb_modm_tstart        = 0;        //start offset of sampling time
float hb_modm_t_samplepoint = 0;        //
float hb_modm_table_dt      = hb_modm_period/255;
float hb_modm_n_samplepoint = 0;
float hb_modm_rem_samplepoint= 0;
float hb_modm_v_samplepoint = 0;

float hb_mod_ra             = hb_mod_ratio / 100;
float hb_signal             = 0;

//RESP
float resp_period           = 1000000*1/resp_freq;  //microSec      
float resp_n                = 1;
float resp_n_sample         = 0;        //The maximum number of sampling points in the signal
float resp_tend             = 0;        //The remainder of sampling points in the signal
float resp_tstart           = 0;        //start offset of sampling time
float resp_t_samplepoint    = 0;           
float resp_table_dt         = resp_period/255;                                            
float resp_n_samplepoint    = 0;
float resp_rem_samplepoint  = 0;
float resp_v_samplepoint    = 0;
float resp_signal           = 0;

//SNORE Paramater
float snore_period          = 1000000*1/snore_freq;  //microSec
float snore_n               = 1;
float snore_n_sample        = 0;        //The maximum number of sampling points in the signal
float snore_tend            = 0;        //The remainder of sampling points in the signal
float snore_tstart          = 0;        //start offset of sampling time
float snore_t_samplepoint   = 0;        //
float snore_table_dt        = snore_period/255; 
float snore_n_samplepoint   = 0;
float snore_rem_samplepoint = 0;
float snore_v_samplepoint   = 0;
int snore_cycle             = 0;
float snore_signal          = 0;

int pwidth_1 = 0;
int pwidth_2 = 0;
int pwidth_3 = 0;

//Signal Culcurate
void signal_culc(){
    
//    ta.reset();     
//    ta.start();
    
//HB section
//HB_carr
        hb_carr_n_sample = (hb_carr_period - hb_carr_tstart) / sample_dt;
        hb_carr_tend = fmod((hb_carr_period - hb_carr_tstart) , sample_dt);     
        hb_carr_t_samplepoint = hb_carr_tstart + sample_dt * hb_carr_n; //time of sampling point
        hb_carr_n_samplepoint = hb_carr_t_samplepoint / hb_carr_table_dt;
        hb_carr_rem_samplepoint = fmod(hb_carr_t_samplepoint , hb_carr_table_dt);       
        hb_carr_v_samplepoint = (hb_carr_rem_samplepoint/hb_carr_table_dt)*(coswave[(int)hb_carr_n_samplepoint+1]-coswave[(int)hb_carr_n_samplepoint])+coswave[(int)hb_carr_n_samplepoint];
        if(hb_carr_n == (int)hb_carr_n_sample) {
            hb_carr_n =1;
            hb_carr_tstart = sample_dt - hb_carr_tend;
            }          
        else {
            hb_carr_n++;           
            }
//HB_mod
//Acosωct+(Ama/2)cos(ωc+ωm)t+(Ama/2)cos(ωc-ωm)t     fcarr(t) = Acosωct,ma = modulation ratio,
        hb_modp_n_sample = (hb_modp_period - hb_modp_tstart) / sample_dt;
        hb_modp_tend = fmod((hb_modp_period - hb_modp_tstart) , sample_dt);     
        hb_modp_t_samplepoint = hb_modp_tstart + sample_dt * hb_modp_n; //time of sampling point    
        hb_modp_n_samplepoint = hb_modp_t_samplepoint / hb_modp_table_dt;
        hb_modp_rem_samplepoint = fmod(hb_modp_t_samplepoint , hb_modp_table_dt);
        hb_modp_v_samplepoint = hb_mod_ra*((hb_modp_rem_samplepoint/hb_modp_table_dt)*(coswave[(int)hb_modp_n_samplepoint+1]-coswave[(int)hb_modp_n_samplepoint])+coswave[(int)hb_modp_n_samplepoint]);
        if(hb_modp_n == (int)hb_modp_n_sample) {
            hb_modp_n =1;
            hb_modp_tstart = sample_dt - hb_modp_tend;
            }
        else {
            hb_modp_n++;           
            }

        hb_modm_n_sample = (hb_modm_period - hb_modm_tstart) / sample_dt;
        hb_modm_tend = fmod((hb_modm_period - hb_modm_tstart) , sample_dt);     
        hb_modm_t_samplepoint = hb_modm_tstart + sample_dt * hb_modm_n; //time of sampling point    
        hb_modm_n_samplepoint = hb_modm_t_samplepoint / hb_modm_table_dt;
        hb_modm_rem_samplepoint = fmod(hb_modm_t_samplepoint , hb_modm_table_dt);
        hb_modm_v_samplepoint = hb_mod_ra*((hb_modm_rem_samplepoint/hb_modm_table_dt)*(coswave[(int)hb_modm_n_samplepoint+1]-coswave[(int)hb_modm_n_samplepoint])+coswave[(int)hb_modm_n_samplepoint]);
        if(hb_modm_n == (int)hb_modm_n_sample) {
            hb_modm_n =1;
            hb_modm_tstart = sample_dt - hb_modm_tend;
            }
        else {
            hb_modm_n++;           
            }
        
//HB_AM MOD   
        hb_signal = hb_carr_level*(hb_carr_v_samplepoint + (0.5*hb_modp_v_samplepoint)+(0.5*hb_modm_v_samplepoint))+0.5;//0-1 -> 0V-3.3V

//RESP section
        resp_n_sample = (resp_period - resp_tstart) / sample_dt;
        resp_tend = fmod((resp_period - resp_tstart) , sample_dt);
        resp_t_samplepoint = resp_tstart + sample_dt * resp_n; //time of sampling point
        resp_n_samplepoint = resp_t_samplepoint / resp_table_dt;
        resp_rem_samplepoint = fmod(resp_t_samplepoint , resp_table_dt);
        resp_v_samplepoint = resp_level*((resp_rem_samplepoint/resp_table_dt)*(coswave[(int)resp_n_samplepoint+1]-coswave[(int)resp_n_samplepoint])+coswave[(int)resp_n_samplepoint]);
        resp_signal = resp_v_samplepoint+0.5;                 //0-1 -> 0V-3.3V
        if(resp_n == (int)resp_n_sample) {
            resp_n =1;
            resp_tstart = sample_dt - resp_tend;
            }      
        else {
            resp_n++;         
            }
            
//SNORE section
        snore_n_sample = (snore_period - snore_tstart) / sample_dt;
        snore_tend = fmod((snore_period - snore_tstart) , sample_dt);
        snore_t_samplepoint = snore_tstart + sample_dt * snore_n; //time of sampling point
        snore_n_samplepoint = snore_t_samplepoint / snore_table_dt;
        snore_rem_samplepoint = fmod(snore_t_samplepoint , snore_table_dt);
        snore_v_samplepoint = snore_level*((snore_rem_samplepoint/snore_table_dt)*(coswave[(int)snore_n_samplepoint+1]-coswave[(int)snore_n_samplepoint])+coswave[(int)snore_n_samplepoint]);
        if(snore_n == (int)snore_n_sample) {
            snore_n =1;
            snore_tstart = sample_dt - snore_tend;
            }
        else {
            snore_n++;          
            }      
        if (snore_cycle <= snore_oncycle) {
            snore_cycle++;
            }
        else if (snore_cycle>snore_oncycle && snore_cycle <= snore_allcycle){
            snore_v_samplepoint = 0;
            snore_cycle++;
            }
        else {
            snore_cycle = 0;
            }

//test
//       test = !test;        

        snore_signal = snore_v_samplepoint+0.5; //0-1 -> 0V-3.3V
            
//PWM Output Pulse width
        pwidth_1 = hb_signal * sample_dt;
        pwidth_2 = resp_signal * sample_dt;
        pwidth_3 = snore_signal * sample_dt;
        
//ta.stop();  
//printf("time= %d \n",ta.read_us());
}

void attime(){  
    signal_culc();
}


int main() {

//Make Cos wave
    int i;
    for(i=0;i<=255;i++){                                                        //256->255
        coswave[i]=0.5*(cos(2.0*3.1415*i/256));                                 //256->256       
    }
    i = 0;

    signal_1.period_us(sample_dt);                //Pulse_cycle = 100usec = 10kHz
    signal_2.period_us(sample_dt);
    signal_2.period_us(sample_dt);
    
    int j;
    j = sample_dt;
    timer.attach_us(&attime,j);

    while(1) {
        signal_1.pulsewidth_us(pwidth_1);
        signal_2.pulsewidth_us(pwidth_2);
        signal_3.pulsewidth_us(pwidth_3);
    }
}
