#include "mbed.h"

//PWM
PwmOut pwm(p23);

//Ticker
Ticker timer;

//Timer
//Timer ta;

//Digital Out
DigitalOut test(p20);

//Cos Wave
float coswave[256];

//User set Wave Paramater
int sample_dt          = 100;      //microsec 10kHz
float freq             = 200;      //Hz
float level            = 1;      //min=0 max=1


float period           = 1000000*1/freq;  //microSec      
float n                = 0;
float n_sample         = 0;        //The maximum number of sampling points in the signal
float tend             = 0;        //The remainder of sampling points in the signal
float tstart           = 0;        //start offset of sampling time
float t_samplepoint    = 0;           
float table_dt         = period/256;                                            
float n_samplepoint    = 0;
float rem_samplepoint  = 0;
float v_samplepoint    = 0;
float signal           = 0;

int pwidth = 0;

//Signal Culcurate


//Signal type parameter
void signal_culc(){
    
 //RESP section
        n_sample = (period - tstart) / sample_dt;
        tend = fmod((period - tstart) , sample_dt);
        if(tend == 0){
            n_sample = n_sample-1;
            }
        else {
            }
        t_samplepoint = tstart + sample_dt * n; //time of sampling point
        n_samplepoint = t_samplepoint / table_dt;
        rem_samplepoint = fmod(t_samplepoint , table_dt);
        v_samplepoint = level*(coswave[(int)n_samplepoint]-(rem_samplepoint/table_dt)*(coswave[(int)n_samplepoint]-coswave[(int)n_samplepoint+1]));
        signal = v_samplepoint+0.5;                 //0-1 -> 0V-3.3V
        if(n == (int)n_sample) {
            n =0;
            tstart = sample_dt - tend;
            }      
        else {
            n++;         
            }
             
//PWM Output Pulse width
        pwidth = signal * sample_dt;  
        
        pwm.pulsewidth_us(pwidth);   
}

void attime(){  
    signal_culc();
}


int main() {

//Make Cos wave
    int i;
    for(i=0;i<=255;i++){                                                        //256->255
        coswave[i]=0.5*(cos(2.0*3.1415*i/256));                                 //256->256       
    }
    i = 0;

    pwm.period_us(sample_dt);                //Pulse_cycle = 100usec = 10kHz
    
    int j;
    j = sample_dt;
    timer.attach_us(&attime,j);

    while(1) {

    }
}
