#include "mbed.h"
#include "uLCD_4DGL.h"
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include "rtos.h"
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut fan(p20);
#include "emic2.h"
uLCD_4DGL uLCD(p28, p27, p29);
emic2 myTTS(p9, p10); //serial RX,TX pins to emic
//uLCD_4DGL uLCD(p28, p27, p29);
Serial pc(p13, p14); //this is the xbee
Serial pc2(USBTX, USBRX); //this is a computer connected to the mbed for testing purposes
Mutex m;
class TMP36
{
public:
TMP36(PinName pin);
TMP36();
float read();
private:
//class sets up the AnalogIn pin
AnalogIn _pin;
};
TMP36::TMP36(PinName pin) : _pin(pin) {} //This is an initializer list … more to come in class
// _pin(pin) means pass pin to the AnalogIn constructor
float TMP36::read()
{
//convert sensor reading to temperature in degrees C
return ((_pin.read()*3.3)-0.500)*100.0;
}
TMP36 myTMP36(p15);

void ttsThread(void const *args) {
    printf("starting up\n\r");
    myTTS.volume(18); //max volume
    string sentence;
    char letter;
    /*
    Whlie there is stuff in the buffer, continue to take characters out of the buffer
    and append it to the char array sentence
    When hit with a punctuation, send to TTS module
    If we see an *, which is sent by the toggle button, toggle the lamp.
    Erase sentence when finished with a command
    Need mutex so serial communications don't interrupt each other.
    */
    while(1) {
        if(pc.readable()){
            m.lock();
            myled2 = 1;
            int a = pc.getc();
            myled2 = 0;
            letter = (char)a;
            sentence = sentence + letter;
            if(letter == '!' || letter == '.' || letter == '?') {
                sentence = "S" + sentence + "\r";
                myTTS.speakf("%s", sentence);
                myTTS.ready();
                sentence = "";
            } else if (letter == '*') {
                fan = !fan;
                myled = !myled;
                sentence = "";   
            }
            m.unlock();
        }

        Thread::wait(1);
    }
}
int main() {
    Thread thread1(ttsThread);
    float tempC, tempF;
    int blue, red, color;
    while(1) {
    tempC = myTMP36.read(); //convert to degrees F
    tempF = (9.0*tempC)/5.0 + 32.0; //print current temp
    uLCD.cls();
    red = (tempF) * 2.55;
    (red <= 0 ? red = 0 : red = red);
    (red >= 255 ? red = 255 : red = red);
    blue = 255 - red;
    red = red << 16;
    color = red + blue;
    uLCD.color(color);
    m.lock();
    //send through xbee to pc
    pc.printf("%f\n", tempC);
    //send through usb for debugging
    pc2.printf("%f\n\r", tempC);
    uLCD.printf("%5.2f C \n\n%5.2f F \n\r\n", tempC, tempF);
    if(tempF < 32) {
        uLCD.printf("It's cold!");
    } else if (tempF < 50) {
        uLCD.printf("It's a little\nchilly!");
    } else if (tempF < 70) {
        uLCD.printf("It's not bad out,\nenjoy the day!");
    } else if (tempF < 85) {
        uLCD.printf("Ahh room\ntemperature!");
    } else {
        uLCD.printf("It's pretty hot!");
    }
    m.unlock();
    Thread::wait(500);
    }
}